/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.mocks;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.druid.server.mocks.MockAsyncContext;
import org.apache.druid.server.mocks.MockHttpServletRequest;

public class MockHttpServletResponse
implements HttpServletResponse {
    public Multimap<String, String> headers = Multimaps.newListMultimap(new LinkedHashMap(), ArrayList::new);
    private Supplier<Map<String, String>> trailerSupplier;
    public final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int statusCode;
    private String contentType;
    private String characterEncoding;

    public static MockHttpServletResponse forRequest(MockHttpServletRequest req) {
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.newAsyncContext(() -> {
            MockAsyncContext retVal = new MockAsyncContext();
            retVal.response = response;
            return retVal;
        });
        return response;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset a committed ServletResponse");
        }
        this.headers.clear();
        this.statusCode = 0;
        this.contentType = null;
        this.characterEncoding = null;
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey((Object)name);
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public void sendError(int sc, String msg) {
        throw new UnsupportedOperationException();
    }

    public void sendError(int sc) {
        throw new UnsupportedOperationException();
    }

    public void sendRedirect(String location) {
        throw new UnsupportedOperationException();
    }

    public void setDateHeader(String name, long date) {
        throw new UnsupportedOperationException();
    }

    public void addDateHeader(String name, long date) {
        throw new UnsupportedOperationException();
    }

    public void setHeader(String name, String value) {
        this.headers.removeAll((Object)name);
        this.headers.put((Object)name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
    }

    public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException();
    }

    public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException();
    }

    public void setStatus(int sc) {
        this.statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        throw new UnsupportedOperationException();
    }

    public int getStatus() {
        return this.statusCode;
    }

    @Nullable
    public String getHeader(String name) {
        Collection vals = this.headers.get((Object)name);
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return (String)vals.iterator().next();
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.get((Object)name);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }

            public void write(int b) {
                MockHttpServletResponse.this.baos.write(b);
            }

            public void write(@NotNull byte[] b) {
                MockHttpServletResponse.this.baos.write(b, 0, b.length);
            }

            public void write(@NotNull byte[] b, int off, int len) {
                MockHttpServletResponse.this.baos.write(b, off, len);
            }
        };
    }

    public PrintWriter getWriter() {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public void setContentLength(int len) {
        throw new UnsupportedOperationException();
    }

    public void setContentLengthLong(long len) {
        throw new UnsupportedOperationException();
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public void flushBuffer() {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    public void forceCommitted() {
        if (!this.isCommitted()) {
            this.baos.write(1234);
        }
    }

    public boolean isCommitted() {
        return this.baos.size() > 0;
    }

    public void setLocale(Locale loc) {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.trailerSupplier = supplier;
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.trailerSupplier;
    }
}

