/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util.datasets;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.sql.calcite.util.datasets.TestDataSet;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;

public class InputSourceBasedTestDataset
implements TestDataSet {
    protected final InputSource inputSource;
    protected final InputFormat inputFormat;
    protected final DataSchema dataSchema;

    public InputSourceBasedTestDataset(DataSchema dataSchema, InputFormat inputFormat, InputSource inputSource) {
        this.inputSource = inputSource;
        this.inputFormat = inputFormat;
        this.dataSchema = dataSchema;
    }

    @Override
    public String getName() {
        return this.getDataSchema().getDataSource();
    }

    @Override
    public final DataSegment makeSegment(QueryableIndex index) {
        DataSegment segment = DataSegment.builder().dataSource(this.getName()).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        return segment;
    }

    @Override
    public final QueryableIndex makeIndex(ObjectMapper jsonMapper, File tmpDir) {
        return IndexBuilder.create((ObjectMapper)jsonMapper).inputTmpDir(tmpDir).tmpDir(tmpDir).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(this.getIndexSchema()).inputSource(this.getInputSource()).inputFormat(this.getInputFormat()).transform(this.getDataSchema().getTransformSpec()).buildMMappedIndex();
    }

    public IncrementalIndexSchema getIndexSchema() {
        return new IncrementalIndexSchema.Builder().withTimestampSpec(this.getDataSchema().getTimestampSpec()).withMetrics(this.getDataSchema().getAggregators()).withDimensionsSpec(this.getDataSchema().getDimensionsSpec()).withRollup(this.getDataSchema().getGranularitySpec().isRollup()).withQueryGranularity(this.getDataSchema().getGranularitySpec().getQueryGranularity()).build();
    }

    public RowSignature getInputRowSignature() {
        RowSignature.Builder rsBuilder = RowSignature.builder();
        for (DimensionSchema dimensionSchema : this.getDataSchema().getDimensionsSpec().getDimensions()) {
            rsBuilder.add(dimensionSchema.getName(), dimensionSchema.getColumnType());
        }
        return rsBuilder.build();
    }

    protected DataSchema getDataSchema() {
        return this.dataSchema;
    }

    protected InputSource getInputSource() {
        return this.inputSource;
    }

    protected InputFormat getInputFormat() {
        return this.inputFormat;
    }
}

