/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.test.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestSegmentUtils;
import org.apache.druid.segment.loading.AcquireSegmentAction;
import org.apache.druid.segment.loading.NoopSegmentCacheManager;
import org.apache.druid.segment.loading.TombstoneSegmentizerFactory;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class TestSegmentCacheManager
extends NoopSegmentCacheManager {
    private final List<DataSegment> cachedSegments;
    private final Map<DataSegment, ReferenceCountedSegmentProvider> referenceProviders;
    private final List<DataSegment> observedBootstrapSegments;
    private final List<DataSegment> observedSegments;
    private final List<DataSegment> observedSegmentsRemovedFromCache;
    private final AtomicInteger observedShutdownBootstrapCount;

    public TestSegmentCacheManager() {
        this((Set<DataSegment>)ImmutableSet.of());
    }

    public TestSegmentCacheManager(Set<DataSegment> segmentsToCache) {
        this.cachedSegments = ImmutableList.copyOf(segmentsToCache);
        this.referenceProviders = new ConcurrentHashMap<DataSegment, ReferenceCountedSegmentProvider>();
        this.observedBootstrapSegments = new CopyOnWriteArrayList<DataSegment>();
        this.observedSegments = new CopyOnWriteArrayList<DataSegment>();
        this.observedSegmentsRemovedFromCache = new CopyOnWriteArrayList<DataSegment>();
        this.observedShutdownBootstrapCount = new AtomicInteger(0);
    }

    @Override
    public boolean canHandleSegments() {
        return true;
    }

    @Override
    public List<DataSegment> getCachedSegments() {
        return this.cachedSegments;
    }

    @Override
    public void bootstrap(DataSegment segment, SegmentLazyLoadFailCallback loadFailed) {
        this.observedBootstrapSegments.add(segment);
    }

    @Override
    public void load(DataSegment segment) {
        this.observedSegments.add(segment);
    }

    private ReferenceCountedSegmentProvider getSegmentInternal(DataSegment segment) {
        return this.referenceProviders.compute(segment, (s, existingProvider) -> {
            if (existingProvider == null) {
                if (s.isTombstone()) {
                    return ReferenceCountedSegmentProvider.of((Segment)TombstoneSegmentizerFactory.segmentForTombstone((DataSegment)s));
                }
                return ReferenceCountedSegmentProvider.of((Segment)new TestSegmentUtils.SegmentForTesting(s.getDataSource(), (Interval)s.getLoadSpec().get("interval"), MapUtils.getString((Map)s.getLoadSpec(), (String)"version")));
            }
            return existingProvider;
        });
    }

    @Override
    public Optional<Segment> acquireCachedSegment(DataSegment dataSegment) {
        if (this.observedSegmentsRemovedFromCache.contains(dataSegment)) {
            return Optional.empty();
        }
        return this.getSegmentInternal(dataSegment).acquireReference();
    }

    @Override
    public AcquireSegmentAction acquireSegment(DataSegment dataSegment) {
        if (this.observedSegmentsRemovedFromCache.contains(dataSegment)) {
            return AcquireSegmentAction.missingSegment();
        }
        return new AcquireSegmentAction(() -> Futures.immediateFuture((Object)this.getSegmentInternal(dataSegment)), null);
    }

    @Override
    public void shutdownBootstrap() {
        this.observedShutdownBootstrapCount.incrementAndGet();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void storeInfoFile(DataSegment segment) {
    }

    @Override
    public void removeInfoFile(DataSegment segment) {
    }

    @Override
    public void drop(DataSegment segment) {
        this.getSegmentInternal(segment).close();
        this.observedSegmentsRemovedFromCache.add(segment);
    }

    public List<DataSegment> getObservedBootstrapSegments() {
        return this.observedBootstrapSegments;
    }

    public List<DataSegment> getObservedSegments() {
        return this.observedSegments;
    }

    public List<DataSegment> getObservedSegmentsRemovedFromCache() {
        return this.observedSegmentsRemovedFromCache;
    }

    public AtomicInteger getObservedShutdownBootstrapCount() {
        return this.observedShutdownBootstrapCount;
    }
}

