/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class DruidDataSource {
    private final String name;
    private final Map<String, String> properties;
    private final ConcurrentMap<SegmentId, DataSegment> idToSegmentMap = new ConcurrentHashMap<SegmentId, DataSegment>();

    public DruidDataSource(String name, Map<String, String> properties) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.properties = properties;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    public DataSegment getSegment(SegmentId segmentId) {
        return (DataSegment)this.idToSegmentMap.get(segmentId);
    }

    public Collection<DataSegment> getSegments() {
        return Collections.unmodifiableCollection(this.idToSegmentMap.values());
    }

    public void removeSegmentsIf(Predicate<DataSegment> filter) {
        this.idToSegmentMap.values().removeIf(filter);
    }

    public DruidDataSource addSegment(DataSegment dataSegment) {
        this.idToSegmentMap.put(dataSegment.getId(), dataSegment);
        return this;
    }

    public boolean addSegmentIfAbsent(DataSegment dataSegment) {
        return this.idToSegmentMap.putIfAbsent(dataSegment.getId(), dataSegment) == null;
    }

    @Nullable
    public DataSegment removeSegment(SegmentId segmentId) {
        return (DataSegment)this.idToSegmentMap.remove(segmentId);
    }

    public boolean isEmpty() {
        return this.idToSegmentMap.isEmpty();
    }

    public ImmutableDruidDataSource toImmutableDruidDataSource() {
        return new ImmutableDruidDataSource(this.name, this.properties, this.idToSegmentMap);
    }

    public String toString() {
        return "DruidDataSource{properties=" + this.properties + ", partitions=" + this.idToSegmentMap.values() + "}";
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Use ImmutableDruidDataSource instead");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Use ImmutableDruidDataSource instead");
    }
}

