/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.UUID;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;

public class LocalDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(LocalDataSegmentPusher.class);
    public static final String INDEX_DIR = "index";
    public static final String INDEX_ZIP_FILENAME = "index.zip";
    private final LocalDataSegmentPusherConfig config;

    @Inject
    public LocalDataSegmentPusher(LocalDataSegmentPusherConfig config) {
        this.config = config;
    }

    public String getPathForHadoop() {
        return this.config.getStorageDirectory().getAbsoluteFile().toURI().toString();
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public DataSegment push(File dataSegmentFile, DataSegment segment, boolean useUniquePath) throws IOException {
        return this.pushToPath(dataSegmentFile, segment, this.getStorageDir(segment, useUniquePath));
    }

    public DataSegment pushToPath(File dataSegmentFile, DataSegment segment, String storageDirSuffix) throws IOException {
        File baseStorageDir = this.config.getStorageDirectory();
        File outDir = new File(baseStorageDir, storageDirSuffix);
        log.debug("Copying segment[%s] to local filesystem at location[%s]", new Object[]{segment.getId(), outDir.toString()});
        segment = segment.withBinaryVersion(SegmentUtils.getVersionFromDir((File)dataSegmentFile));
        if (dataSegmentFile.equals(outDir)) {
            long size = 0L;
            for (File file : dataSegmentFile.listFiles()) {
                size += file.length();
            }
            return segment.withLoadSpec(this.makeLoadSpec(outDir.toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir((File)dataSegmentFile));
        }
        if (this.config.isZip()) {
            return this.pushZip(dataSegmentFile, outDir, segment);
        }
        return this.pushNoZip(dataSegmentFile, outDir, segment);
    }

    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)finalIndexZipFilePath.getPath());
    }

    private String makeIntermediateDir() {
        return "intermediate_pushes/" + UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSegment pushZip(File inDir, File outDir, DataSegment baseSegment) throws IOException {
        File tmpSegmentDir = new File(this.config.getStorageDirectory(), this.makeIntermediateDir());
        File tmpIndexFile = new File(tmpSegmentDir, INDEX_ZIP_FILENAME);
        log.debug("Creating intermediate directory[%s] for segment[%s].", new Object[]{tmpSegmentDir.toString(), baseSegment.getId()});
        FileUtils.mkdirp((File)tmpSegmentDir);
        try {
            log.debug("Compressing files from[%s] to [%s]", new Object[]{inDir, tmpIndexFile});
            long size = CompressionUtils.zip((File)inDir, (File)tmpIndexFile, (boolean)true);
            FileUtils.mkdirp((File)outDir);
            File indexFileTarget = new File(outDir, tmpIndexFile.getName());
            if (!tmpIndexFile.renameTo(indexFileTarget)) {
                throw new IOE("Failed to rename [%s] to [%s]", new Object[]{tmpIndexFile, indexFileTarget});
            }
            DataSegment dataSegment = baseSegment.withLoadSpec(this.makeLoadSpec(new File(outDir, INDEX_ZIP_FILENAME).toURI())).withSize(size);
            return dataSegment;
        }
        finally {
            FileUtils.deleteDirectory((File)tmpSegmentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSegment pushNoZip(File inDir, File outDir, DataSegment baseSegment) throws IOException {
        File tmpSegmentDir = new File(this.config.getStorageDirectory(), this.makeIntermediateDir());
        FileUtils.mkdirp((File)tmpSegmentDir);
        try {
            long size;
            block9: {
                File[] files = inDir.listFiles();
                if (files == null) {
                    throw new IOE("Cannot list directory [%s]", new Object[]{inDir});
                }
                size = 0L;
                for (File file : files) {
                    if (file.isFile()) {
                        size += file.length();
                    } else {
                        throw new IOE("Unexpected subdirectory [%s]", new Object[]{file.getName()});
                    }
                    FileUtils.linkOrCopy((File)file, (File)new File(tmpSegmentDir, file.getName()));
                }
                File segmentDir = new File(outDir, INDEX_DIR);
                FileUtils.mkdirp((File)outDir);
                try {
                    Files.move(tmpSegmentDir.toPath(), segmentDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException e) {
                    if (!segmentDir.exists()) break block9;
                    Files.move(segmentDir.toPath(), new File(outDir, StringUtils.format((String)"%s_old_%s", (Object[])new Object[]{INDEX_DIR, UUID.randomUUID()})).toPath(), StandardCopyOption.ATOMIC_MOVE);
                    Files.move(tmpSegmentDir.toPath(), segmentDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
                }
            }
            DataSegment dataSegment = baseSegment.withLoadSpec(this.makeLoadSpec(new File(outDir, INDEX_DIR).toURI())).withSize(size);
            return dataSegment;
        }
        finally {
            FileUtils.deleteDirectory((File)tmpSegmentDir);
        }
    }
}

