/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.utils.CollectionUtils;

public class AuthConfig {
    public static final String DRUID_AUTHENTICATION_RESULT = "Druid-Authentication-Result";
    public static final String DRUID_AUTHORIZATION_CHECKED = "Druid-Authorization-Checked";
    public static final String DRUID_ALLOW_UNSECURED_PATH = "Druid-Allow-Unsecured-Path";
    public static final String ALLOW_ALL_NAME = "allowAll";
    public static final String ANONYMOUS_NAME = "anonymous";
    public static final String TRUSTED_DOMAIN_NAME = "trustedDomain";
    public static final Set<String> ALLOWED_CONTEXT_KEYS = ImmutableSet.of((Object)"sqlStringifyArrays", (Object)"dartQueryId", (Object)"sqlQueryId");
    @JsonProperty
    private final List<String> authenticatorChain;
    @JsonProperty
    private final List<String> authorizers;
    @JsonProperty
    private final List<String> unsecuredPaths;
    @JsonProperty
    private final boolean allowUnauthenticatedHttpOptions;
    @JsonProperty
    private final boolean authorizeQueryContextParams;
    @JsonProperty
    private final Set<String> unsecuredContextKeys;
    @JsonProperty
    private final Set<String> securedContextKeys;
    @JsonProperty
    private final boolean enableInputSourceSecurity;

    public AuthConfig() {
        this(null, null, null, false, false, null, null, false);
    }

    @JsonCreator
    public AuthConfig(@JsonProperty(value="authenticatorChain") List<String> authenticatorChain, @JsonProperty(value="authorizers") List<String> authorizers, @JsonProperty(value="unsecuredPaths") List<String> unsecuredPaths, @JsonProperty(value="allowUnauthenticatedHttpOptions") boolean allowUnauthenticatedHttpOptions, @JsonProperty(value="authorizeQueryContextParams") boolean authorizeQueryContextParams, @JsonProperty(value="unsecuredContextKeys") Set<String> unsecuredContextKeys, @JsonProperty(value="securedContextKeys") Set<String> securedContextKeys, @JsonProperty(value="enableInputSourceSecurity") boolean enableInputSourceSecurity) {
        this.authenticatorChain = authenticatorChain;
        this.authorizers = authorizers;
        this.unsecuredPaths = unsecuredPaths == null ? Collections.emptyList() : unsecuredPaths;
        this.allowUnauthenticatedHttpOptions = allowUnauthenticatedHttpOptions;
        this.authorizeQueryContextParams = authorizeQueryContextParams;
        this.unsecuredContextKeys = unsecuredContextKeys == null ? Collections.emptySet() : unsecuredContextKeys;
        this.securedContextKeys = securedContextKeys;
        this.enableInputSourceSecurity = enableInputSourceSecurity;
    }

    public List<String> getAuthenticatorChain() {
        return this.authenticatorChain;
    }

    public List<String> getAuthorizers() {
        return this.authorizers;
    }

    public List<String> getUnsecuredPaths() {
        return this.unsecuredPaths;
    }

    public boolean isAllowUnauthenticatedHttpOptions() {
        return this.allowUnauthenticatedHttpOptions;
    }

    public boolean authorizeQueryContextParams() {
        return this.authorizeQueryContextParams;
    }

    public boolean isEnableInputSourceSecurity() {
        return this.enableInputSourceSecurity;
    }

    public Set<String> contextKeysToAuthorize(Set<String> userKeys) {
        if (!this.authorizeQueryContextParams) {
            return ImmutableSet.of();
        }
        Set keysToCheck = CollectionUtils.subtract(userKeys, ALLOWED_CONTEXT_KEYS);
        keysToCheck = CollectionUtils.subtract((Set)keysToCheck, this.unsecuredContextKeys);
        if (this.securedContextKeys != null) {
            keysToCheck = CollectionUtils.intersect((Set)keysToCheck, this.securedContextKeys);
        }
        return keysToCheck;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig that = (AuthConfig)o;
        return this.allowUnauthenticatedHttpOptions == that.allowUnauthenticatedHttpOptions && this.authorizeQueryContextParams == that.authorizeQueryContextParams && Objects.equals(this.authenticatorChain, that.authenticatorChain) && Objects.equals(this.authorizers, that.authorizers) && Objects.equals(this.unsecuredPaths, that.unsecuredPaths) && Objects.equals(this.unsecuredContextKeys, that.unsecuredContextKeys) && Objects.equals(this.securedContextKeys, that.securedContextKeys) && Objects.equals(this.enableInputSourceSecurity, that.enableInputSourceSecurity);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorChain, this.authorizers, this.unsecuredPaths, this.allowUnauthenticatedHttpOptions, this.authorizeQueryContextParams, this.unsecuredContextKeys, this.securedContextKeys, this.enableInputSourceSecurity);
    }

    public String toString() {
        return "AuthConfig{authenticatorChain=" + this.authenticatorChain + ", authorizers=" + this.authorizers + ", unsecuredPaths=" + this.unsecuredPaths + ", allowUnauthenticatedHttpOptions=" + this.allowUnauthenticatedHttpOptions + ", enableQueryContextAuthorization=" + this.authorizeQueryContextParams + ", unsecuredContextKeys=" + this.unsecuredContextKeys + ", securedContextKeys=" + this.securedContextKeys + ", enableInputSourceSecurity=" + this.enableInputSourceSecurity + "}";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> authenticatorChain;
        private List<String> authorizers;
        private List<String> unsecuredPaths;
        private boolean allowUnauthenticatedHttpOptions;
        private boolean authorizeQueryContextParams;
        private Set<String> unsecuredContextKeys;
        private Set<String> securedContextKeys;
        private boolean enableInputSourceSecurity;

        public Builder setAuthenticatorChain(List<String> authenticatorChain) {
            this.authenticatorChain = authenticatorChain;
            return this;
        }

        public Builder setAuthorizers(List<String> authorizers) {
            this.authorizers = authorizers;
            return this;
        }

        public Builder setUnsecuredPaths(List<String> unsecuredPaths) {
            this.unsecuredPaths = unsecuredPaths;
            return this;
        }

        public Builder setAllowUnauthenticatedHttpOptions(boolean allowUnauthenticatedHttpOptions) {
            this.allowUnauthenticatedHttpOptions = allowUnauthenticatedHttpOptions;
            return this;
        }

        public Builder setAuthorizeQueryContextParams(boolean authorizeQueryContextParams) {
            this.authorizeQueryContextParams = authorizeQueryContextParams;
            return this;
        }

        public Builder setUnsecuredContextKeys(Set<String> unsecuredContextKeys) {
            this.unsecuredContextKeys = unsecuredContextKeys;
            return this;
        }

        public Builder setSecuredContextKeys(Set<String> securedContextKeys) {
            this.securedContextKeys = securedContextKeys;
            return this;
        }

        public Builder setEnableInputSourceSecurity(boolean enableInputSourceSecurity) {
            this.enableInputSourceSecurity = enableInputSourceSecurity;
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this.authenticatorChain, this.authorizers, this.unsecuredPaths, this.allowUnauthenticatedHttpOptions, this.authorizeQueryContextParams, this.unsecuredContextKeys, this.securedContextKeys, this.enableInputSourceSecurity);
        }
    }
}

