/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.HttpIndexingServiceClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.CacheModule;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.IndexingServiceFirehoseModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.NodeTypeConfig;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.QueryablePeonModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.actions.LocalTaskActionClientFactory;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskAuditLogConfig;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTaskClientFactory;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.SingleTaskBackgroundRunner;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.worker.executor.ExecutorLifecycle;
import org.apache.druid.indexing.worker.executor.ExecutorLifecycleConfig;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.OmniDataSegmentArchiver;
import org.apache.druid.segment.loading.OmniDataSegmentKiller;
import org.apache.druid.segment.loading.OmniDataSegmentMover;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.ServiceAnnouncingChatHandlerProvider;
import org.apache.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.apache.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierFactory;
import org.apache.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import org.apache.druid.server.coordination.BatchDataSegmentAnnouncer;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.initialization.jetty.ChatHandlerServerModule;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.eclipse.jetty.server.Server;

@Command(name="peon", description="Runs a Peon, this is an individual forked \"task\" used as part of the indexing service. This should rarely, if ever, be used directly. See http://druid.io/docs/latest/design/peons.html for a description")
public class CliPeon
extends GuiceRunnable {
    @Arguments(description="task.json status.json report.json", required=true)
    public List<String> taskAndStatusFile;
    private String taskLogPath;
    private String taskStatusPath;
    private String taskReportPath;
    @Option(name={"--nodeType"}, title="nodeType", description="Set the node type to expose on ZK")
    public String nodeType = "indexer-executor";
    private static final Logger log = new Logger(CliPeon.class);
    @Inject
    private Properties properties;

    public CliPeon() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                CliPeon.this.taskLogPath = CliPeon.this.taskAndStatusFile.get(0);
                CliPeon.this.taskStatusPath = CliPeon.this.taskAndStatusFile.get(1);
                CliPeon.this.taskReportPath = CliPeon.this.taskAndStatusFile.get(2);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/peon");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.rowIngestionMeters.type", (Key)Key.get(RowIngestionMetersFactory.class), (Key)Key.get(DropwizardRowIngestionMetersFactory.class));
                MapBinder rowIngestionMetersHandlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(RowIngestionMetersFactory.class));
                rowIngestionMetersHandlerProviderBinder.addBinding((Object)"dropwizard").to(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
                binder.bind(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.chathandler.type", (Key)Key.get(ChatHandlerProvider.class), (Key)Key.get(ServiceAnnouncingChatHandlerProvider.class));
                MapBinder handlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ChatHandlerProvider.class));
                handlerProviderBinder.addBinding((Object)"announce").to(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
                handlerProviderBinder.addBinding((Object)"noop").to(NoopChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(NoopChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(TaskToolboxFactory.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.auditlog", TaskAuditLogConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.peon.taskActionClient.retry", RetryPolicyConfig.class);
                this.configureTaskActionClient(binder);
                binder.bind(IndexingServiceClient.class).to(HttpIndexingServiceClient.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<IndexTaskClientFactory<ParallelIndexTaskClient>>(){}).to(ParallelIndexTaskClientFactory.class).in(LazySingleton.class);
                binder.bind(RetryPolicyFactory.class).in(LazySingleton.class);
                Binders.dataSegmentKillerBinder((Binder)binder);
                binder.bind(DataSegmentKiller.class).to(OmniDataSegmentKiller.class).in(LazySingleton.class);
                Binders.dataSegmentMoverBinder((Binder)binder);
                binder.bind(DataSegmentMover.class).to(OmniDataSegmentMover.class).in(LazySingleton.class);
                Binders.dataSegmentArchiverBinder((Binder)binder);
                binder.bind(DataSegmentArchiver.class).to(OmniDataSegmentArchiver.class).in(LazySingleton.class);
                binder.bind(ExecutorLifecycle.class).in(ManageLifecycle.class);
                LifecycleModule.register((Binder)binder, ExecutorLifecycle.class);
                binder.bind(ExecutorLifecycleConfig.class).toInstance((Object)new ExecutorLifecycleConfig().setTaskFile(new File(CliPeon.this.taskLogPath)).setStatusFile(new File(CliPeon.this.taskStatusPath)));
                binder.bind(TaskReportFileWriter.class).toInstance((Object)new TaskReportFileWriter(new File(CliPeon.this.taskReportPath)));
                binder.bind(TaskRunner.class).to(SingleTaskBackgroundRunner.class);
                binder.bind(QuerySegmentWalker.class).to(SingleTaskBackgroundRunner.class);
                binder.bind(SingleTaskBackgroundRunner.class).in(ManageLifecycle.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime.cache", CacheConfig.class);
                binder.install((Module)new CacheModule());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.segment.handoff", CoordinatorBasedSegmentHandoffNotifierConfig.class);
                binder.bind(SegmentHandoffNotifierFactory.class).to(CoordinatorBasedSegmentHandoffNotifierFactory.class).in(LazySingleton.class);
                binder.bind(SegmentLoaderConfig.class).toInstance((Object)new SegmentLoaderConfig().withLocations(Collections.emptyList()));
                binder.bind(CoordinatorClient.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, SegmentListerResource.class);
                binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig(ServerType.fromString((String)CliPeon.this.nodeType)));
                LifecycleModule.register((Binder)binder, Server.class);
            }

            private void configureTaskActionClient(Binder binder) {
                PolyBind.createChoice((Binder)binder, (String)"druid.peon.mode", (Key)Key.get(TaskActionClientFactory.class), (Key)Key.get(RemoteTaskActionClientFactory.class));
                MapBinder taskActionBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskActionClientFactory.class));
                taskActionBinder.addBinding((Object)"local").to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.storage", TaskStorageConfig.class);
                binder.bind(TaskStorage.class).to(HeapMemoryTaskStorage.class).in(LazySingleton.class);
                binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
                binder.bind(IndexerMetadataStorageCoordinator.class).to(IndexerSQLMetadataStorageCoordinator.class).in(LazySingleton.class);
                taskActionBinder.addBinding((Object)"remote").to(RemoteTaskActionClientFactory.class).in(LazySingleton.class);
            }

            @Provides
            @LazySingleton
            public Task readTask(@Json ObjectMapper mapper, ExecutorLifecycleConfig config) {
                try {
                    return (Task)mapper.readValue(config.getTaskFile(), Task.class);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Provides
            @LazySingleton
            @Named(value="druidDataSource")
            public String getDataSourceFromTask(Task task) {
                return task.getDataSource();
            }

            @Provides
            @LazySingleton
            @Named(value="druidTaskId")
            public String getTaskIDFromTask(Task task) {
                return task.getId();
            }

            @Provides
            public SegmentListerResource getSegmentListerResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, @Nullable BatchDataSegmentAnnouncer announcer) {
                return new SegmentListerResource(jsonMapper, smileMapper, announcer, null);
            }
        }, (Object)new QueryablePeonModule(), (Object)new IndexingServiceFirehoseModule(), (Object)new ChatHandlerServerModule(this.properties), (Object)new LookupModule());
    }

    @Override
    public void run() {
        try {
            Injector injector = this.makeInjector();
            try {
                Lifecycle lifecycle = this.initLifecycle(injector);
                Thread hook = new Thread(() -> {
                    log.info("Running shutdown hook", new Object[0]);
                    lifecycle.stop();
                });
                Runtime.getRuntime().addShutdownHook(hook);
                ((ExecutorLifecycle)injector.getInstance(ExecutorLifecycle.class)).join();
                Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                for (Thread thread : threadSet) {
                    if (thread.isDaemon() || thread == Thread.currentThread()) continue;
                    log.info("Thread [%s] is non daemon.", new Object[]{thread});
                }
                lifecycle.stop();
                try {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (IllegalStateException e) {
                    log.warn("Cannot remove shutdown hook, already shutting down", new Object[0]);
                }
            }
            catch (Throwable t) {
                log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            log.info("Finished peon task", new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

