/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.netty.util.SuppressForbidden;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

@Command(name="dump-segment", description="Dump segment data")
public class DumpSegment
extends GuiceRunnable {
    private static final Logger log = new Logger(DumpSegment.class);
    @Option(name={"-d", "--directory"}, title="directory", description="Directory containing segment data.", required=true)
    public String directory;
    @Option(name={"-o", "--out"}, title="file", description="File to write to, or omit to write to stdout.", required=false)
    public String outputFileName;
    @Option(name={"--filter"}, title="json", description="Filter, JSON encoded, or omit to include all rows. Only used if dumping rows.", required=false)
    public String filterJson = null;
    @Option(name={"-c", "--column"}, title="column", description="Column to include, specify multiple times for multiple columns, or omit to include all columns.", required=false)
    public List<String> columnNamesFromCli = Lists.newArrayList();
    @Option(name={"--time-iso8601"}, title="Format __time column in ISO8601 format rather than long. Only used if dumping rows.", required=false)
    public boolean timeISO8601 = false;
    @Option(name={"--dump"}, title="type", description="Dump either 'rows' (default), 'metadata', or 'bitmaps'", required=false)
    public String dumpTypeString = DumpType.ROWS.toString();
    @Option(name={"--decompress-bitmaps"}, title="Dump bitmaps as arrays rather than base64-encoded compressed bitmaps. Only used if dumping bitmaps.", required=false)
    public boolean decompressBitmaps = false;

    public DumpSegment() {
        super(log);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        DumpType dumpType;
        Injector injector = this.makeInjector();
        IndexIO indexIO = (IndexIO)injector.getInstance(IndexIO.class);
        try {
            dumpType = DumpType.valueOf(StringUtils.toUpperCase((String)this.dumpTypeString));
        }
        catch (Exception e) {
            throw new IAE("Not a valid dump type: %s", new Object[]{this.dumpTypeString});
        }
        try (QueryableIndex index = indexIO.loadIndex(new File(this.directory));){
            switch (dumpType) {
                case ROWS: {
                    this.runDump(injector, index);
                    return;
                }
                case METADATA: {
                    this.runMetadata(injector, index);
                    return;
                }
                case BITMAPS: {
                    this.runBitmaps(injector, index);
                    return;
                }
                default: {
                    throw new ISE("WTF?! dumpType[%s] has no handler?", new Object[]{dumpType});
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void runMetadata(final Injector injector, final QueryableIndex index) throws IOException {
        final ObjectMapper objectMapper = ((ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class))).copy().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        final SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new TableDataSource("dataSource"), (QuerySegmentSpec)new SpecificSegmentSpec(new SegmentDescriptor(index.getDataInterval(), "0", 0)), (ColumnIncluderator)new ListColumnIncluderator(this.getColumnsToInclude(index)), Boolean.valueOf(false), null, EnumSet.allOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), Boolean.valueOf(false));
        this.withOutputStream(new Function<OutputStream, Object>(){

            public Object apply(final OutputStream out) {
                DumpSegment.evaluateSequenceForSideEffects(Sequences.map((Sequence)DumpSegment.executeQuery(injector, index, (Query)query), (Function)new Function<SegmentAnalysis, Object>(){

                    public Object apply(SegmentAnalysis analysis) {
                        try {
                            objectMapper.writeValue(out, (Object)analysis);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        return null;
                    }
                }));
                return null;
            }
        });
    }

    private void runDump(Injector injector, QueryableIndex index) throws IOException {
        final ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        QueryableIndexStorageAdapter adapter = new QueryableIndexStorageAdapter(index);
        final List<String> columnNames = this.getColumnsToInclude(index);
        DimFilter filter = this.filterJson != null ? (DimFilter)objectMapper.readValue(this.filterJson, DimFilter.class) : null;
        final Sequence cursors = adapter.makeCursors(Filters.toFilter(filter), index.getDataInterval().withChronology((Chronology)ISOChronology.getInstanceUTC()), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        this.withOutputStream(new Function<OutputStream, Object>(){

            public Object apply(final OutputStream out) {
                Sequence sequence = Sequences.map((Sequence)cursors, (Function)new Function<Cursor, Object>(){

                    public Object apply(Cursor cursor) {
                        ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                        List selectors = columnNames.stream().map(arg_0 -> ((ColumnSelectorFactory)columnSelectorFactory).makeColumnValueSelector(arg_0)).collect(Collectors.toList());
                        while (!cursor.isDone()) {
                            LinkedHashMap row = Maps.newLinkedHashMap();
                            for (int i = 0; i < columnNames.size(); ++i) {
                                String columnName = (String)columnNames.get(i);
                                Object value = ((BaseObjectColumnValueSelector)selectors.get(i)).getObject();
                                if (DumpSegment.this.timeISO8601 && ((String)columnNames.get(i)).equals("__time")) {
                                    row.put(columnName, new DateTime(value, DateTimeZone.UTC).toString());
                                    continue;
                                }
                                row.put(columnName, value);
                            }
                            try {
                                out.write(objectMapper.writeValueAsBytes((Object)row));
                                out.write(10);
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                            cursor.advance();
                        }
                        return null;
                    }
                });
                DumpSegment.evaluateSequenceForSideEffects(sequence);
                return null;
            }
        });
    }

    private void runBitmaps(Injector injector, QueryableIndex index) throws IOException {
        ConciseBitmapSerdeFactory bitmapSerdeFactory;
        final ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
        if (bitmapFactory instanceof ConciseBitmapFactory) {
            bitmapSerdeFactory = new ConciseBitmapSerdeFactory();
        } else if (bitmapFactory instanceof RoaringBitmapFactory) {
            bitmapSerdeFactory = new RoaringBitmapSerdeFactory(null);
        } else {
            throw new ISE("Don't know which BitmapSerdeFactory to use for BitmapFactory[%s]!", new Object[]{bitmapFactory.getClass().getName()});
        }
        List<String> columnNames = this.getColumnsToInclude(index);
        this.withOutputStream(new Function<OutputStream, Object>((BitmapSerdeFactory)bitmapSerdeFactory, columnNames, index){
            final /* synthetic */ BitmapSerdeFactory val$bitmapSerdeFactory;
            final /* synthetic */ List val$columnNames;
            final /* synthetic */ QueryableIndex val$index;
            {
                this.val$bitmapSerdeFactory = bitmapSerdeFactory;
                this.val$columnNames = list;
                this.val$index = queryableIndex;
            }

            public Object apply(OutputStream out) {
                try {
                    JsonGenerator jg = objectMapper.getFactory().createGenerator(out);
                    jg.writeStartObject();
                    jg.writeObjectField("bitmapSerdeFactory", (Object)this.val$bitmapSerdeFactory);
                    jg.writeFieldName("bitmaps");
                    jg.writeStartObject();
                    for (String columnName : this.val$columnNames) {
                        ColumnHolder columnHolder = this.val$index.getColumnHolder(columnName);
                        BitmapIndex bitmapIndex = columnHolder.getBitmapIndex();
                        if (bitmapIndex == null) {
                            jg.writeNullField(columnName);
                            continue;
                        }
                        jg.writeFieldName(columnName);
                        jg.writeStartObject();
                        for (int i = 0; i < bitmapIndex.getCardinality(); ++i) {
                            String val = NullHandling.nullToEmptyIfNeeded((String)bitmapIndex.getValue(i));
                            if (val == null) continue;
                            ImmutableBitmap bitmap = bitmapIndex.getBitmap(i);
                            if (DumpSegment.this.decompressBitmaps) {
                                jg.writeStartArray();
                                for (int rowNum : bitmap) {
                                    jg.writeNumber(rowNum);
                                }
                                jg.writeEndArray();
                                continue;
                            }
                            byte[] bytes = this.val$bitmapSerdeFactory.getObjectStrategy().toBytes((Object)bitmap);
                            if (bytes == null) continue;
                            jg.writeBinary(bytes);
                        }
                        jg.writeEndObject();
                    }
                    jg.writeEndObject();
                    jg.writeEndObject();
                    jg.close();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                return null;
            }
        });
    }

    private List<String> getColumnsToInclude(QueryableIndex index) {
        LinkedHashSet columnNames = Sets.newLinkedHashSet(this.columnNamesFromCli);
        if (columnNames.isEmpty()) {
            columnNames.add("__time");
            Iterables.addAll((Collection)columnNames, (Iterable)index.getColumnNames());
        } else {
            for (String columnName : ImmutableList.copyOf((Collection)columnNames)) {
                if (index.getColumnHolder(columnName) != null) continue;
                columnNames.remove(columnName);
            }
        }
        return ImmutableList.copyOf((Collection)columnNames);
    }

    @SuppressForbidden(reason="System#out")
    private <T> T withOutputStream(Function<OutputStream, T> f) throws IOException {
        if (this.outputFileName == null) {
            return (T)f.apply((Object)System.out);
        }
        try (FileOutputStream out = new FileOutputStream(this.outputFileName);){
            Object object = f.apply((Object)out);
            return (T)object;
        }
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/tool");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(9999);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(DruidProcessingConfig.class).toInstance((Object)new DruidProcessingConfig(){

                    public String getFormatString() {
                        return "processing-%s";
                    }

                    public int intermediateComputeSizeBytes() {
                        return 0x6400000;
                    }

                    public int getNumThreads() {
                        return 1;
                    }

                    public int columnCacheSizeBytes() {
                        return 0x1900000;
                    }
                });
                binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
            }
        });
    }

    private static <T> Sequence<T> executeQuery(Injector injector, QueryableIndex index, Query<T> query) {
        QueryRunnerFactoryConglomerate conglomerate = (QueryRunnerFactoryConglomerate)injector.getInstance(QueryRunnerFactoryConglomerate.class);
        QueryRunnerFactory factory = conglomerate.findFactory(query);
        QueryRunner runner = factory.createRunner((Segment)new QueryableIndexSegment("segment", index));
        return factory.getToolchest().mergeResults(factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)ImmutableList.of((Object)runner))).run(QueryPlus.wrap(query), (Map)Maps.newHashMap());
    }

    private static <T> void evaluateSequenceForSideEffects(Sequence<T> sequence) {
        sequence.accumulate(null, (accumulated, in) -> null);
    }

    private static enum DumpType {
        ROWS,
        METADATA,
        BITMAPS;

    }
}

