/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;

public abstract class ServerRunnable
extends GuiceRunnable {
    public ServerRunnable(Logger log) {
        super(log);
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        Lifecycle lifecycle = this.initLifecycle(injector);
        try {
            lifecycle.join();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected static class DiscoverySideEffectsProvider
    implements Provider<Child> {
        @Inject
        @Self
        private DruidNode druidNode;
        @Inject
        private DruidNodeAnnouncer announcer;
        @Inject
        private Lifecycle lifecycle;
        @Inject
        private Injector injector;
        private final String nodeType;
        private final List<Class<? extends DruidService>> serviceClasses;

        public DiscoverySideEffectsProvider(String nodeType, List<Class<? extends DruidService>> serviceClasses) {
            this.nodeType = nodeType;
            this.serviceClasses = serviceClasses;
        }

        public Child get() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Class<? extends DruidService> clazz : this.serviceClasses) {
                DruidService service = (DruidService)this.injector.getInstance(clazz);
                builder.put((Object)service.getName(), (Object)service);
            }
            final DiscoveryDruidNode discoveryDruidNode = new DiscoveryDruidNode(this.druidNode, this.nodeType, (Map)builder.build());
            this.lifecycle.addHandler(new Lifecycle.Handler(){

                public void start() {
                    announcer.announce(discoveryDruidNode);
                }

                public void stop() {
                    announcer.unannounce(discoveryDruidNode);
                }
            }, Lifecycle.Stage.LAST);
            return new Child();
        }

        public static class Child {
        }
    }
}

