/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli.convert;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.cli.convert.PropertyConverter;

public class PrefixRename
implements PropertyConverter {
    private final String prefix;
    private final String outputPrefix;
    private final AtomicBoolean ran = new AtomicBoolean(false);

    public PrefixRename(String prefix, String outputPrefix) {
        this.prefix = prefix;
        this.outputPrefix = outputPrefix;
    }

    @Override
    public boolean canHandle(String property) {
        return property.startsWith(this.prefix) && !this.ran.get();
    }

    @Override
    public Map<String, String> convert(Properties properties) {
        if (!this.ran.getAndSet(true)) {
            LinkedHashMap retVal = Maps.newLinkedHashMap();
            for (String property : properties.stringPropertyNames()) {
                if (!property.startsWith(this.prefix)) continue;
                retVal.put(property.replace(this.prefix, this.outputPrefix), properties.getProperty(property));
            }
            return retVal;
        }
        return ImmutableMap.of();
    }
}

