/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.druid.cli.CliCoordinator;
import org.apache.druid.cli.CliOverlord;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.http.OverlordProxyServlet;
import org.apache.druid.server.http.RedirectFilter;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;

class CoordinatorJettyServerInitializer
implements JettyServerInitializer {
    private static List<String> UNSECURED_PATHS = Lists.newArrayList((Object[])new String[]{"/favicon.png", "/pages/*", "/coordinator-console/*", "/index.html", "/old-console/*", "/coordinator/false", "/overlord/false", "/status/health", "/druid/coordinator/v1/isLeader"});
    private final DruidCoordinatorConfig config;
    private final boolean beOverlord;
    private final ServerConfig serverConfig;

    @Inject
    CoordinatorJettyServerInitializer(DruidCoordinatorConfig config, Properties properties, ServerConfig serverConfig) {
        this.config = config;
        this.beOverlord = CliCoordinator.isOverlord(properties);
        this.serverConfig = serverConfig;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        root.setInitParameter("org.eclipse.jetty.servlet.Default.redirectWelcome", "true");
        root.setWelcomeFiles(new String[]{"index.html"});
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        root.addServlet(holderPwd, "/");
        if (this.config.getConsoleStatic() == null) {
            root.setBaseResource(Resource.newClassPathResource((String)"org/apache/druid/console"));
        } else {
            root.setResourceBase(this.config.getConsoleStatic());
        }
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, (List)authConfig.getUnsecuredPaths());
        if (this.beOverlord) {
            AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, CliOverlord.UNSECURED_PATHS);
        }
        List authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(GuiceFilter.class, "/druid-internal/*", null);
        root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
        root.addFilter(GuiceFilter.class, "/info/*", null);
        root.addFilter(GuiceFilter.class, "/druid/coordinator/*", null);
        if (this.beOverlord) {
            root.addFilter(GuiceFilter.class, "/druid/indexer/*", null);
        }
        root.addFilter(GuiceFilter.class, "/druid-ext/*", null);
        root.addFilter(GuiceFilter.class, "/coordinator/*", null);
        if (!this.beOverlord) {
            root.addServlet(new ServletHolder((Servlet)injector.getInstance(OverlordProxyServlet.class)), "/druid/indexer/*");
        }
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel())});
        server.setHandler((Handler)handlerList);
    }
}

