/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import java.util.List;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.guice.CacheModule;
import org.apache.druid.guice.FireDepartmentsProvider;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.NodeTypeConfig;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.RealtimeManagerConfig;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.metadata.MetadataSegmentPublisher;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.NoopSegmentPublisher;
import org.apache.druid.segment.realtime.RealtimeManager;
import org.apache.druid.segment.realtime.SegmentPublisher;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.ServiceAnnouncingChatHandlerProvider;
import org.apache.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.apache.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierFactory;
import org.apache.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.eclipse.jetty.server.Server;

public class RealtimeModule
implements Module {
    public void configure(Binder binder) {
        PolyBind.createChoiceWithDefault((Binder)binder, (String)"druid.publish.type", (Key)Key.get(SegmentPublisher.class), (String)"metadata");
        MapBinder publisherBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(SegmentPublisher.class));
        publisherBinder.addBinding((Object)"noop").to(NoopSegmentPublisher.class).in(LazySingleton.class);
        publisherBinder.addBinding((Object)"metadata").to(MetadataSegmentPublisher.class).in(LazySingleton.class);
        PolyBind.createChoice((Binder)binder, (String)"druid.realtime.rowIngestionMeters.type", (Key)Key.get(RowIngestionMetersFactory.class), (Key)Key.get(DropwizardRowIngestionMetersFactory.class));
        MapBinder rowIngestionMetersHandlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(RowIngestionMetersFactory.class));
        rowIngestionMetersHandlerProviderBinder.addBinding((Object)"dropwizard").to(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
        binder.bind(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
        PolyBind.createChoice((Binder)binder, (String)"druid.realtime.chathandler.type", (Key)Key.get(ChatHandlerProvider.class), (Key)Key.get(ServiceAnnouncingChatHandlerProvider.class));
        MapBinder handlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ChatHandlerProvider.class));
        handlerProviderBinder.addBinding((Object)"announce").to(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
        handlerProviderBinder.addBinding((Object)"noop").to(NoopChatHandlerProvider.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime", RealtimeManagerConfig.class);
        binder.bind((TypeLiteral)new TypeLiteral<List<FireDepartment>>(){}).toProvider(FireDepartmentsProvider.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.segment.handoff", CoordinatorBasedSegmentHandoffNotifierConfig.class);
        binder.bind(SegmentHandoffNotifierFactory.class).to(CoordinatorBasedSegmentHandoffNotifierFactory.class).in(LazySingleton.class);
        binder.bind(CoordinatorClient.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime.cache", CacheConfig.class);
        binder.install((Module)new CacheModule());
        binder.bind(QuerySegmentWalker.class).to(RealtimeManager.class).in(ManageLifecycle.class);
        binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig(ServerType.REALTIME));
        binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
        binder.bind(QueryCountStatsProvider.class).to(QueryResource.class).in(LazySingleton.class);
        Jerseys.addResource((Binder)binder, QueryResource.class);
        Jerseys.addResource((Binder)binder, SegmentListerResource.class);
        LifecycleModule.register((Binder)binder, QueryResource.class);
        LifecycleModule.register((Binder)binder, Server.class);
        binder.bind(SegmentManager.class).in(LazySingleton.class);
        binder.bind(ZkCoordinator.class).in(ManageLifecycle.class);
        LifecycleModule.register((Binder)binder, ZkCoordinator.class);
    }
}

