/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

class MiddleManagerJettyServerInitializer
implements JettyServerInitializer {
    private static Logger log = new Logger(MiddleManagerJettyServerInitializer.class);
    private final ServerConfig serverConfig;
    private final AuthConfig authConfig;
    private static List<String> UNSECURED_PATHS = Collections.singletonList("/status/health");

    @Inject
    public MiddleManagerJettyServerInitializer(ServerConfig serverConfig, AuthConfig authConfig) {
        this.serverConfig = serverConfig;
        this.authConfig = authConfig;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, (List)authConfig.getUnsecuredPaths());
        List authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel()), new DefaultHandler()});
        server.setHandler((Handler)handlerList);
    }
}

