/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;

public abstract class ServerRunnable
extends GuiceRunnable {
    public ServerRunnable(Logger log) {
        super(log);
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        Lifecycle lifecycle = this.initLifecycle(injector);
        try {
            lifecycle.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void bindAnnouncer(Binder binder, DiscoverySideEffectsProvider provider) {
        binder.bind(DiscoverySideEffectsProvider.Child.class).toProvider((Provider)provider).in(LazySingleton.class);
        LifecycleModule.registerKey((Binder)binder, (Key)Key.get(DiscoverySideEffectsProvider.Child.class));
    }

    public static void bindAnnouncer(Binder binder, Class<? extends Annotation> annotation, DiscoverySideEffectsProvider provider) {
        binder.bind(DiscoverySideEffectsProvider.Child.class).annotatedWith(annotation).toProvider((Provider)provider).in(LazySingleton.class);
        LifecycleModule.registerKey((Binder)binder, (Key)Key.get(DiscoverySideEffectsProvider.Child.class, annotation));
    }

    protected static class DiscoverySideEffectsProvider
    implements Provider<Child> {
        @Inject
        @Self
        private DruidNode druidNode;
        @Inject
        private DruidNodeAnnouncer announcer;
        @Inject
        private ServiceAnnouncer legacyAnnouncer;
        @Inject
        private Lifecycle lifecycle;
        @Inject
        private Injector injector;
        private final NodeType nodeType;
        private final List<Class<? extends DruidService>> serviceClasses;
        private final boolean useLegacyAnnouncer;

        public static Builder builder(NodeType nodeType) {
            return new Builder(nodeType);
        }

        private DiscoverySideEffectsProvider(NodeType nodeType, List<Class<? extends DruidService>> serviceClasses, boolean useLegacyAnnouncer) {
            this.nodeType = nodeType;
            this.serviceClasses = serviceClasses;
            this.useLegacyAnnouncer = useLegacyAnnouncer;
        }

        public Child get() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Class<? extends DruidService> clazz : this.serviceClasses) {
                DruidService service = (DruidService)this.injector.getInstance(clazz);
                builder.put((Object)service.getName(), (Object)service);
            }
            final DiscoveryDruidNode discoveryDruidNode = new DiscoveryDruidNode(this.druidNode, this.nodeType, (Map)builder.build());
            this.lifecycle.addHandler(new Lifecycle.Handler(){

                public void start() {
                    announcer.announce(discoveryDruidNode);
                    if (useLegacyAnnouncer) {
                        legacyAnnouncer.announce(discoveryDruidNode.getDruidNode());
                    }
                }

                public void stop() {
                    if (useLegacyAnnouncer) {
                        legacyAnnouncer.unannounce(discoveryDruidNode.getDruidNode());
                    }
                    announcer.unannounce(discoveryDruidNode);
                }
            }, Lifecycle.Stage.ANNOUNCEMENTS);
            return new Child();
        }

        public static class Builder {
            private NodeType nodeType;
            private List<Class<? extends DruidService>> serviceClasses = ImmutableList.of();
            private boolean useLegacyAnnouncer;

            public Builder(NodeType nodeType) {
                this.nodeType = nodeType;
            }

            public Builder serviceClasses(List<Class<? extends DruidService>> serviceClasses) {
                this.serviceClasses = serviceClasses;
                return this;
            }

            public Builder useLegacyAnnouncer(boolean useLegacyAnnouncer) {
                this.useLegacyAnnouncer = useLegacyAnnouncer;
                return this;
            }

            public DiscoverySideEffectsProvider build() {
                return new DiscoverySideEffectsProvider(this.nodeType, this.serviceClasses, this.useLegacyAnnouncer);
            }
        }

        public static class Child {
        }
    }
}

