/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.cli.RouterJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.curator.discovery.DiscoveryModule;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.RouterProcessingModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.http.JettyHttpClientModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.server.AsyncQueryForwardingServlet;
import org.apache.druid.server.http.RouterResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.router.AvaticaConnectionBalancer;
import org.apache.druid.server.router.CoordinatorRuleManager;
import org.apache.druid.server.router.ManagementProxyConfig;
import org.apache.druid.server.router.QueryHostFinder;
import org.apache.druid.server.router.Router;
import org.apache.druid.server.router.TieredBrokerConfig;
import org.apache.druid.server.router.TieredBrokerHostSelector;
import org.apache.druid.server.router.TieredBrokerSelectorStrategiesProvider;
import org.apache.druid.server.router.TieredBrokerSelectorStrategy;
import org.eclipse.jetty.server.Server;

@Command(name="router", description="Experimental! Understands tiers and routes things to different brokers, see https://druid.apache.org/docs/latest/development/router.html for a description")
public class CliRouter
extends ServerRunnable {
    private static final Logger log = new Logger(CliRouter.class);

    public CliRouter() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new RouterProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new JettyHttpClientModule("druid.router.http", Router.class), (Object)JettyHttpClientModule.global(), binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/router");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8888);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(9088);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.router", TieredBrokerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.router.avatica.balancer", AvaticaConnectionBalancer.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.router.managementProxy", ManagementProxyConfig.class);
            binder.bind(CoordinatorRuleManager.class);
            LifecycleModule.register((Binder)binder, CoordinatorRuleManager.class);
            binder.bind(TieredBrokerHostSelector.class).in(ManageLifecycle.class);
            binder.bind(QueryHostFinder.class).in(LazySingleton.class);
            binder.bind((TypeLiteral)new TypeLiteral<List<TieredBrokerSelectorStrategy>>(){}).toProvider(TieredBrokerSelectorStrategiesProvider.class).in(LazySingleton.class);
            binder.bind(QueryCountStatsProvider.class).to(AsyncQueryForwardingServlet.class).in(LazySingleton.class);
            binder.bind(JettyServerInitializer.class).to(RouterJettyServerInitializer.class).in(LazySingleton.class);
            Jerseys.addResource((Binder)binder, RouterResource.class);
            LifecycleModule.register((Binder)binder, RouterResource.class);
            LifecycleModule.register((Binder)binder, Server.class);
            DiscoveryModule.register((Binder)binder, Self.class);
            CliRouter.bindAnnouncer(binder, ServerRunnable.DiscoverySideEffectsProvider.builder(NodeType.ROUTER).build());
        }, (Object)new LookupSerdeModule());
    }
}

