/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.opencsv.CSVParser;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.xml.bind.DatatypeConverter;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.server.DruidNode;
import org.apache.druid.timeline.DataSegment;

@Command(name="export-metadata", description="Exports the contents of a Druid Derby metadata store to CSV files to assist with cluster migration. This tool also provides the ability to rewrite segment locations in the Derby metadata to assist with deep storage migration.")
public class ExportMetadata
extends GuiceRunnable {
    @Option(name={"--connectURI"}, description="Database JDBC connection string", required=true)
    private String connectURI;
    @Option(name={"--user"}, description="Database username")
    private String user = null;
    @Option(name={"--password"}, description="Database password")
    private String password = null;
    @Option(name={"--base"}, description="Base table name")
    private String base = "druid";
    @Option(name={"-b", "--s3bucket"}, title="s3bucket", description="S3 bucket of the migrated segments", required=false)
    public String s3Bucket = null;
    @Option(name={"-k", "--s3baseKey"}, title="s3baseKey", description="S3 baseKey of the migrated segments", required=false)
    public String s3baseKey = null;
    @Option(name={"-h", "--hadoopStorageDirectory"}, title="hadoopStorageDirectory", description="hadoopStorageDirectory of the migrated segments", required=false)
    public String hadoopStorageDirectory = null;
    @Option(name={"-n", "--newLocalPath"}, title="newLocalPath", description="newLocalPath of the migrated segments", required=false)
    public String newLocalPath = null;
    @Option(name={"-o", "--output-path"}, title="output-path", description="CSV output path", required=false)
    public String outputPath = null;
    @Option(name={"-x", "--use-hex-blobs"}, title="use-hex-blobs", description="Write BLOB payloads as hex strings", required=false)
    public boolean useHexBlobs = false;
    @Option(name={"-t", "--booleans-as-strings"}, title="booleans-as-strings", description="Write boolean values as true/false strings instead of 1/0", required=false)
    public boolean booleansAsStrings = false;
    private static final Logger log = new Logger(ExportMetadata.class);
    private static final CSVParser PARSER = new CSVParser();
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    public ExportMetadata() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(MetadataStorageConnectorConfig.class), (Object)new MetadataStorageConnectorConfig(){

                public String getConnectURI() {
                    return ExportMetadata.this.connectURI;
                }

                public String getUser() {
                    return ExportMetadata.this.user;
                }

                public String getPassword() {
                    return ExportMetadata.this.password;
                }
            });
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(MetadataStorageTablesConfig.class), (Object)MetadataStorageTablesConfig.fromBase((String)this.base));
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("tools", "localhost", false, Integer.valueOf(-1), null, true, false));
        });
    }

    @Override
    public void run() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ObjectMapper.class, (Object)JSON_MAPPER);
        injectableValues.addValue(DataSegment.PruneLoadSpecHolder.class, (Object)DataSegment.PruneLoadSpecHolder.DEFAULT);
        JSON_MAPPER.setInjectableValues((InjectableValues)injectableValues);
        if (this.hadoopStorageDirectory != null && this.newLocalPath != null) {
            throw new IllegalArgumentException("Only one of s3Bucket, hadoopStorageDirectory, and newLocalPath can be set.");
        }
        if (this.s3Bucket != null && (this.hadoopStorageDirectory != null || this.newLocalPath != null)) {
            throw new IllegalArgumentException("Only one of s3Bucket, hadoopStorageDirectory, and newLocalPath can be set.");
        }
        if (this.s3Bucket != null && this.s3baseKey == null) {
            throw new IllegalArgumentException("s3baseKey must be set if s3Bucket is set.");
        }
        Injector injector = this.makeInjector();
        SQLMetadataConnector dbConnector = (SQLMetadataConnector)injector.getInstance(SQLMetadataConnector.class);
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)injector.getInstance(MetadataStorageTablesConfig.class);
        log.info("Exporting datasource table: " + metadataStorageTablesConfig.getDataSourceTable(), new Object[0]);
        this.exportTable(dbConnector, metadataStorageTablesConfig.getDataSourceTable(), true);
        this.rewriteDatasourceExport(metadataStorageTablesConfig.getDataSourceTable());
        log.info("Exporting segments table: " + metadataStorageTablesConfig.getSegmentsTable(), new Object[0]);
        this.exportTable(dbConnector, metadataStorageTablesConfig.getSegmentsTable(), true);
        this.rewriteSegmentsExport(metadataStorageTablesConfig.getSegmentsTable());
        log.info("Exporting rules table: " + metadataStorageTablesConfig.getRulesTable(), new Object[0]);
        this.exportTable(dbConnector, metadataStorageTablesConfig.getRulesTable(), true);
        this.rewriteRulesExport(metadataStorageTablesConfig.getRulesTable());
        log.info("Exporting config table: " + metadataStorageTablesConfig.getConfigTable(), new Object[0]);
        this.exportTable(dbConnector, metadataStorageTablesConfig.getConfigTable(), true);
        this.rewriteConfigExport(metadataStorageTablesConfig.getConfigTable());
        log.info("Exporting supervisor table: " + metadataStorageTablesConfig.getSupervisorTable(), new Object[0]);
        this.exportTable(dbConnector, metadataStorageTablesConfig.getSupervisorTable(), true);
        this.rewriteSupervisorExport(metadataStorageTablesConfig.getSupervisorTable());
    }

    private void exportTable(SQLMetadataConnector dbConnector, String tableName, boolean withRawFilename) {
        String pathFormatString = withRawFilename ? "%s/%s_raw.csv" : "%s/%s.csv";
        dbConnector.exportTable(StringUtils.toUpperCase((String)tableName), StringUtils.format((String)pathFormatString, (Object[])new Object[]{this.outputPath, tableName}));
    }

    private void rewriteDatasourceExport(String datasourceTableName) {
        String inFile = StringUtils.format((String)"%s/%s_raw.csv", (Object[])new Object[]{this.outputPath, datasourceTableName});
        String outFile = StringUtils.format((String)"%s/%s.csv", (Object[])new Object[]{this.outputPath, datasourceTableName});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parsed = PARSER.parseLine(line);
                StringBuilder newLineBuilder = new StringBuilder();
                newLineBuilder.append(parsed[0]).append(",");
                newLineBuilder.append(parsed[1]).append(",");
                newLineBuilder.append(this.rewriteHexPayloadAsEscapedJson(parsed[2])).append(",");
                newLineBuilder.append(parsed[3]);
                newLineBuilder.append("\n");
                writer.write(newLineBuilder.toString());
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private void rewriteRulesExport(String rulesTableName) {
        String inFile = StringUtils.format((String)"%s/%s_raw.csv", (Object[])new Object[]{this.outputPath, rulesTableName});
        String outFile = StringUtils.format((String)"%s/%s.csv", (Object[])new Object[]{this.outputPath, rulesTableName});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parsed = PARSER.parseLine(line);
                StringBuilder newLineBuilder = new StringBuilder();
                newLineBuilder.append(parsed[0]).append(",");
                newLineBuilder.append(parsed[1]).append(",");
                newLineBuilder.append(parsed[2]).append(",");
                newLineBuilder.append(this.rewriteHexPayloadAsEscapedJson(parsed[3]));
                newLineBuilder.append("\n");
                writer.write(newLineBuilder.toString());
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private void rewriteConfigExport(String configTableName) {
        String inFile = StringUtils.format((String)"%s/%s_raw.csv", (Object[])new Object[]{this.outputPath, configTableName});
        String outFile = StringUtils.format((String)"%s/%s.csv", (Object[])new Object[]{this.outputPath, configTableName});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parsed = PARSER.parseLine(line);
                StringBuilder newLineBuilder = new StringBuilder();
                newLineBuilder.append(parsed[0]).append(",");
                newLineBuilder.append(this.rewriteHexPayloadAsEscapedJson(parsed[1]));
                newLineBuilder.append("\n");
                writer.write(newLineBuilder.toString());
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private void rewriteSupervisorExport(String supervisorTableName) {
        String inFile = StringUtils.format((String)"%s/%s_raw.csv", (Object[])new Object[]{this.outputPath, supervisorTableName});
        String outFile = StringUtils.format((String)"%s/%s.csv", (Object[])new Object[]{this.outputPath, supervisorTableName});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parsed = PARSER.parseLine(line);
                StringBuilder newLineBuilder = new StringBuilder();
                newLineBuilder.append(parsed[0]).append(",");
                newLineBuilder.append(parsed[1]).append(",");
                newLineBuilder.append(parsed[2]).append(",");
                newLineBuilder.append(this.rewriteHexPayloadAsEscapedJson(parsed[3]));
                newLineBuilder.append("\n");
                writer.write(newLineBuilder.toString());
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private void rewriteSegmentsExport(String segmentsTableName) {
        String inFile = StringUtils.format((String)"%s/%s_raw.csv", (Object[])new Object[]{this.outputPath, segmentsTableName});
        String outFile = StringUtils.format((String)"%s/%s.csv", (Object[])new Object[]{this.outputPath, segmentsTableName});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parsed = PARSER.parseLine(line);
                StringBuilder newLineBuilder = new StringBuilder();
                newLineBuilder.append(parsed[0]).append(",");
                newLineBuilder.append(parsed[1]).append(",");
                newLineBuilder.append(parsed[2]).append(",");
                newLineBuilder.append(parsed[3]).append(",");
                newLineBuilder.append(parsed[4]).append(",");
                newLineBuilder.append(this.convertBooleanString(parsed[5])).append(",");
                newLineBuilder.append(parsed[6]).append(",");
                newLineBuilder.append(this.convertBooleanString(parsed[7])).append(",");
                if (this.s3Bucket != null || this.hadoopStorageDirectory != null || this.newLocalPath != null) {
                    newLineBuilder.append(this.makePayloadWithConvertedLoadSpec(parsed[8]));
                } else {
                    newLineBuilder.append(this.rewriteHexPayloadAsEscapedJson(parsed[8]));
                }
                newLineBuilder.append("\n");
                writer.write(newLineBuilder.toString());
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private String makePayloadWithConvertedLoadSpec(String payload) throws IOException {
        DataSegment segment = (DataSegment)JSON_MAPPER.readValue(DatatypeConverter.parseHexBinary((String)payload), DataSegment.class);
        String uniqueId = this.getUniqueIDFromLocalLoadSpec(segment.getLoadSpec());
        String segmentPath = DataSegmentPusher.getDefaultStorageDirWithExistingUniquePath((DataSegment)segment, (String)uniqueId);
        Map<String, Object> newLoadSpec = null;
        if (this.s3Bucket != null) {
            newLoadSpec = this.makeS3LoadSpec(segmentPath);
        } else if (this.hadoopStorageDirectory != null) {
            newLoadSpec = this.makeHDFSLoadSpec(segmentPath);
        } else if (this.newLocalPath != null) {
            newLoadSpec = this.makeLocalLoadSpec(segmentPath);
        }
        if (newLoadSpec != null) {
            segment = new DataSegment(segment.getDataSource(), segment.getInterval(), segment.getVersion(), newLoadSpec, segment.getDimensions(), segment.getMetrics(), segment.getShardSpec(), segment.getBinaryVersion(), segment.getSize());
        }
        String serialized = JSON_MAPPER.writeValueAsString((Object)segment);
        if (this.useHexBlobs) {
            return DatatypeConverter.printHexBinary((byte[])StringUtils.toUtf8((String)serialized));
        }
        return this.escapeJSONForCSV(serialized);
    }

    private String rewriteHexPayloadAsEscapedJson(String payload) {
        if (this.useHexBlobs) {
            return payload;
        }
        String json = StringUtils.fromUtf8((byte[])DatatypeConverter.parseHexBinary((String)payload));
        return this.escapeJSONForCSV(json);
    }

    private String convertBooleanString(String booleanString) {
        if (this.booleansAsStrings) {
            return booleanString;
        }
        return "true".equals(booleanString) ? "1" : "0";
    }

    private String escapeJSONForCSV(String json) {
        return "\"" + StringUtils.replace((String)json, (String)"\"", (String)"\"\"") + "\"";
    }

    private Map<String, Object> makeS3LoadSpec(String segmentPath) {
        return ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)this.s3Bucket, (Object)"key", (Object)StringUtils.format((String)"%s/%s/index.zip", (Object[])new Object[]{this.s3baseKey, segmentPath}));
    }

    private Map<String, Object> makeHDFSLoadSpec(String segmentPath) {
        return ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)StringUtils.format((String)"%s/%s/index.zip", (Object[])new Object[]{this.hadoopStorageDirectory, segmentPath.replace(':', '_')}));
    }

    private Map<String, Object> makeLocalLoadSpec(String segmentPath) {
        return ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)StringUtils.format((String)"%s/%s/index.zip", (Object[])new Object[]{this.newLocalPath, segmentPath}));
    }

    @Nullable
    private String getUniqueIDFromLocalLoadSpec(Map<String, Object> localLoadSpec) {
        String[] splits = ((String)localLoadSpec.get("path")).split("/");
        if (splits.length < 2) {
            return null;
        }
        String maybeUUID = splits[splits.length - 2];
        try {
            UUID.fromString(maybeUUID);
            return maybeUUID;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

