/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.netty.util.SuppressForbidden;
import io.tesla.aether.Repository;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.guice.RepositorySystemSessionProvider;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

@Command(name="pull-deps", description="Pull down dependencies to the local repository specified by druid.extensions.localRepository, extensions directory specified by druid.extensions.extensionsDir and hadoop dependencies directory specified by druid.extensions.hadoopDependenciesDir")
public class PullDependencies
implements Runnable {
    private static final Logger log = new Logger(PullDependencies.class);
    private static final Set<String> EXCLUSIONS = new HashSet<String>();
    private static final List<String> DEFAULT_REMOTE_REPOSITORIES = ImmutableList.of((Object)"https://repo1.maven.org/maven2/");
    private TeslaAether aether;
    @Inject
    public ExtensionsConfig extensionsConfig;
    @Option(name={"-c", "--coordinate"}, title="coordinate", description="Extension coordinate to pull down, followed by a maven coordinate, e.g. org.apache.druid.extensions:mysql-metadata-storage", required=false)
    public List<String> coordinates = new ArrayList<String>();
    @Option(name={"-h", "--hadoop-coordinate"}, title="hadoop coordinate", description="Hadoop dependency to pull down, followed by a maven coordinate, e.g. org.apache.hadoop:hadoop-client:2.4.0", required=false)
    public List<String> hadoopCoordinates = new ArrayList<String>();
    @Option(name={"--no-default-hadoop"}, description="Don't pull down the default hadoop coordinate, i.e., org.apache.hadoop:hadoop-client:2.8.3. If `-h` option is supplied, then default hadoop coordinate will not be downloaded.", required=false)
    public boolean noDefaultHadoop = false;
    @Option(name={"--clean"}, title="Remove exisiting extension and hadoop dependencies directories before pulling down dependencies.", required=false)
    public boolean clean = false;
    @Option(name={"-l", "--localRepository"}, title="A local repository that Maven will use to put downloaded files. Then pull-deps will lay these files out into the extensions directory as needed.", required=false)
    public String localRepository = StringUtils.format((String)"%s/%s", (Object[])new Object[]{System.getProperty("user.home"), ".m2/repository"});
    @Option(name={"-r", "--remoteRepository"}, title="Add a remote repository. Unless --no-default-remote-repositories is provided, these will be used after https://repo1.maven.org/maven2/", required=false)
    List<String> remoteRepositories = new ArrayList<String>();
    @Option(name={"--no-default-remote-repositories"}, description="Don't use the default remote repositories, only use the repositories provided directly via --remoteRepository", required=false)
    public boolean noDefaultRemoteRepositories = false;
    @Option(name={"-d", "--defaultVersion"}, title="Version to use for extension artifacts without version information.", required=false)
    public String defaultVersion = PullDependencies.class.getPackage().getImplementationVersion();
    @Option(name={"--use-proxy"}, title="Use http/https proxy to pull dependencies.", required=false)
    public boolean useProxy = false;
    @Option(name={"--proxy-type"}, title="The proxy type, should be either http or https", required=false)
    public String proxyType = "https";
    @Option(name={"--proxy-host"}, title="The proxy host", required=false)
    public String proxyHost = "";
    @Option(name={"--proxy-port"}, title="The proxy port", required=false)
    public int proxyPort = -1;
    @Option(name={"--proxy-username"}, title="The proxy username", required=false)
    public String proxyUsername = "";
    @Option(name={"--proxy-password"}, title="The proxy password", required=false)
    public String proxyPassword = "";

    public PullDependencies() {
    }

    PullDependencies(TeslaAether aether, ExtensionsConfig extensionsConfig) {
        this.aether = aether;
        this.extensionsConfig = extensionsConfig;
    }

    @Override
    public void run() {
        if (this.aether == null) {
            this.aether = this.getAetherClient();
        }
        File extensionsDir = new File(this.extensionsConfig.getDirectory());
        File hadoopDependenciesDir = new File(this.extensionsConfig.getHadoopDependenciesDir());
        try {
            if (this.clean) {
                FileUtils.deleteDirectory((File)extensionsDir);
                FileUtils.deleteDirectory((File)hadoopDependenciesDir);
            }
            FileUtils.forceMkdir((File)extensionsDir);
            FileUtils.forceMkdir((File)hadoopDependenciesDir);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Unable to clear or create extension directory at [%s]", new Object[]{extensionsDir});
            throw new RuntimeException(e);
        }
        log.info("Start pull-deps with local repository [%s] and remote repositories [%s]", new Object[]{this.localRepository, this.remoteRepositories});
        try {
            File currExtensionDir;
            Artifact versionedArtifact;
            log.info("Start downloading dependencies for extension coordinates: [%s]", new Object[]{this.coordinates});
            for (String coordinate : this.coordinates) {
                coordinate = coordinate.trim();
                versionedArtifact = this.getArtifact(coordinate);
                currExtensionDir = new File(extensionsDir, versionedArtifact.getArtifactId());
                this.createExtensionDirectory(coordinate, currExtensionDir);
                this.downloadExtension(versionedArtifact, currExtensionDir);
            }
            log.info("Finish downloading dependencies for extension coordinates: [%s]", new Object[]{this.coordinates});
            if (!this.noDefaultHadoop && this.hadoopCoordinates.isEmpty()) {
                this.hadoopCoordinates.addAll(TaskConfig.DEFAULT_DEFAULT_HADOOP_COORDINATES);
            }
            log.info("Start downloading dependencies for hadoop extension coordinates: [%s]", new Object[]{this.hadoopCoordinates});
            for (String hadoopCoordinate : this.hadoopCoordinates) {
                versionedArtifact = this.getArtifact(hadoopCoordinate);
                currExtensionDir = new File(hadoopDependenciesDir, versionedArtifact.getArtifactId());
                this.createExtensionDirectory(hadoopCoordinate, currExtensionDir);
                currExtensionDir = new File(currExtensionDir, versionedArtifact.getVersion());
                this.createExtensionDirectory(hadoopCoordinate, currExtensionDir);
                this.downloadExtension(versionedArtifact, currExtensionDir);
            }
            log.info("Finish downloading dependencies for hadoop extension coordinates: [%s]", new Object[]{this.hadoopCoordinates});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Artifact getArtifact(String coordinate) {
        DefaultArtifact versionedArtifact;
        try {
            versionedArtifact = new DefaultArtifact(coordinate);
        }
        catch (IllegalArgumentException e) {
            if (this.defaultVersion != null) {
                versionedArtifact = new DefaultArtifact(coordinate + ":" + this.defaultVersion);
            }
            throw e;
        }
        return versionedArtifact;
    }

    private void downloadExtension(Artifact versionedArtifact, File toLocation) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(versionedArtifact, "runtime"));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}), new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                String scope = node.getDependency().getScope();
                if (scope != null) {
                    if ("provided".equals(scope = StringUtils.toLowerCase((String)scope))) {
                        return false;
                    }
                    if ("test".equals(scope)) {
                        return false;
                    }
                    if ("system".equals(scope)) {
                        return false;
                    }
                }
                if (this.accept(node.getArtifact())) {
                    return false;
                }
                for (DependencyNode parent : parents) {
                    if (!this.accept(parent.getArtifact())) continue;
                    return false;
                }
                return true;
            }

            private boolean accept(Artifact artifact) {
                return EXCLUSIONS.contains(artifact.getGroupId());
            }
        }}));
        try {
            log.info("Start downloading extension [%s]", new Object[]{versionedArtifact});
            List artifacts = this.aether.resolveArtifacts(dependencyRequest);
            for (Artifact artifact : artifacts) {
                if (!EXCLUSIONS.contains(artifact.getGroupId())) {
                    log.info("Adding file [%s] at [%s]", new Object[]{artifact.getFile().getName(), toLocation.getAbsolutePath()});
                    FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)toLocation);
                    continue;
                }
                log.debug("Skipped Artifact[%s]", new Object[]{artifact});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to resolve artifacts for [%s].", new Object[]{dependencyRequest});
            throw new RuntimeException(e);
        }
        log.info("Finish downloading extension [%s]", new Object[]{versionedArtifact});
    }

    @SuppressForbidden(reason="System#out")
    private DefaultTeslaAether getAetherClient() {
        ArrayList<String> remoteUriList = new ArrayList<String>();
        if (!this.noDefaultRemoteRepositories) {
            remoteUriList.addAll(DEFAULT_REMOTE_REPOSITORIES);
        }
        remoteUriList.addAll(this.remoteRepositories);
        ArrayList<Repository> remoteRepositories = new ArrayList<Repository>();
        for (String uri : remoteUriList) {
            try {
                URI u = new URI(uri);
                Repository r = new Repository(uri);
                if (u.getUserInfo() != null) {
                    String[] auth = u.getUserInfo().split(":", 2);
                    if (auth.length == 2) {
                        r.setUsername(auth[0]);
                        r.setPassword(auth[1]);
                    } else {
                        log.warn("Invalid credentials in repository URI, expecting [<user>:<password>], got [%s] for [%s]", new Object[]{u.getUserInfo(), uri});
                    }
                }
                remoteRepositories.add(r);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (log.isTraceEnabled() || log.isDebugEnabled()) {
            return this.createTeslaAether(remoteRepositories);
        }
        PrintStream oldOut = System.out;
        try {
            String uri;
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }

                @Override
                public void write(byte[] b) {
                }

                @Override
                public void write(byte[] b, int off, int len) {
                }
            }, false, StringUtils.UTF8_STRING));
            uri = this.createTeslaAether(remoteRepositories);
            return uri;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        finally {
            System.setOut(oldOut);
        }
    }

    private DefaultTeslaAether createTeslaAether(List<Repository> remoteRepositories) {
        if (!this.useProxy) {
            return new DefaultTeslaAether(this.localRepository, remoteRepositories.toArray(new Repository[0]));
        }
        if (!StringUtils.toLowerCase((String)this.proxyType).equals("http") && !StringUtils.toLowerCase((String)this.proxyType).equals("https")) {
            throw new IllegalArgumentException("invalid proxy type: " + this.proxyType);
        }
        RepositorySystemSession repositorySystemSession = new RepositorySystemSessionProvider(new File(this.localRepository)).get();
        List rl = remoteRepositories.stream().map(r -> {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(r.getId(), "default", r.getUrl());
            if (r.getUsername() != null && r.getPassword() != null) {
                Authentication auth = new AuthenticationBuilder().addUsername(r.getUsername()).addPassword(r.getPassword()).build();
                builder.setAuthentication(auth);
            }
            Authentication proxyAuth = Strings.isNullOrEmpty((String)this.proxyUsername) ? null : new AuthenticationBuilder().addUsername(this.proxyUsername).addPassword(this.proxyPassword).build();
            builder.setProxy(new Proxy(this.proxyType, this.proxyHost, this.proxyPort, proxyAuth));
            return builder.build();
        }).collect(Collectors.toList());
        return new DefaultTeslaAether(rl, repositorySystemSession);
    }

    private void createExtensionDirectory(String coordinate, File atLocation) {
        if (atLocation.isDirectory()) {
            log.info("Directory [%s] already exists, skipping creating a directory", new Object[]{atLocation.getAbsolutePath()});
            return;
        }
        if (!atLocation.mkdir()) {
            throw new ISE("Unable to create directory at [%s] for coordinate [%s]", new Object[]{atLocation.getAbsolutePath(), coordinate});
        }
    }
}

