/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import org.apache.druid.cli.CliMiddleManager;
import org.apache.druid.cli.CliPeon;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.discovery.WorkerNodeService;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.IndexingServiceFirehoseModule;
import org.apache.druid.guice.IndexingServiceInputSourceModule;
import org.apache.druid.guice.IndexingServiceModuleHelper;
import org.apache.druid.guice.IndexingServiceTaskLogsModule;
import org.apache.druid.guice.IndexingServiceTuningConfigModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.QueryablePeonModule;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.guice.annotations.Parent;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.MultipleFileTaskReportFileWriter;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.ThreadingTaskRunner;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.http.ShuffleResource;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.segment.realtime.CliIndexerDataSegmentServerAnnouncerLifecycleHandler;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.UnifiedIndexerAppenderatorsManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.initialization.jetty.CliIndexerServerModule;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.eclipse.jetty.server.Server;

@Command(name="indexer", description="Runs an Indexer. The Indexer is a task execution process that runs each task in a separate thread.")
public class CliIndexer
extends ServerRunnable {
    private static final Logger log = new Logger(CliIndexer.class);
    @Inject
    private Properties properties;

    public CliIndexer() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/indexer");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8091);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8291);
                IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                JsonConfigProvider.bind((Binder)binder, (String)"druid", DruidNode.class, Parent.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                CliPeon.bindTaskConfigAndClients(binder);
                binder.bind(TaskReportFileWriter.class).toInstance((Object)new MultipleFileTaskReportFileWriter());
                binder.bind(TaskRunner.class).to(ThreadingTaskRunner.class);
                binder.bind(QuerySegmentWalker.class).to(ThreadingTaskRunner.class);
                binder.bind(ThreadingTaskRunner.class).in(LazySingleton.class);
                CliPeon.bindRowIngestionMeters(binder);
                CliPeon.bindChatHandler(binder);
                CliPeon.bindPeonDataSegmentHandlers(binder);
                CliPeon.bindRealtimeCache(binder);
                CliPeon.bindCoordinatorHandoffNotiferAndClient(binder);
                CliMiddleManager.bindWorkerManagementClasses(binder);
                binder.bind(AppenderatorsManager.class).to(UnifiedIndexerAppenderatorsManager.class).in(LazySingleton.class);
                binder.bind(ServerTypeConfig.class).toInstance((Object)new ServerTypeConfig(ServerType.INDEXER_EXECUTOR));
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, SegmentListerResource.class);
                LifecycleModule.register((Binder)binder, CliIndexerDataSegmentServerAnnouncerLifecycleHandler.class);
                Jerseys.addResource((Binder)binder, ShuffleResource.class);
                LifecycleModule.register((Binder)binder, Server.class, RemoteChatHandler.class);
                binder.bind(SegmentLoadDropHandler.class).toProvider(Providers.of(null));
                ServerRunnable.bindNodeRoleAndAnnouncer(binder, ServerRunnable.DiscoverySideEffectsProvider.builder(NodeRole.INDEXER).serviceClasses((List<Class<? extends DruidService>>)ImmutableList.of(LookupNodeService.class, WorkerNodeService.class, DataNodeService.class)).build());
            }

            @Provides
            @LazySingleton
            public Worker getWorker(@Self DruidNode node, WorkerConfig config) {
                return new Worker(node.getServiceScheme(), node.getHostAndPortToUse(), config.getIp(), config.getCapacity(), config.getVersion(), "_default_worker_category");
            }

            @Provides
            @LazySingleton
            public WorkerNodeService getWorkerNodeService(WorkerConfig workerConfig) {
                return new WorkerNodeService(workerConfig.getIp(), workerConfig.getCapacity(), workerConfig.getVersion(), "_default_worker_category");
            }

            @Provides
            @LazySingleton
            public DataNodeService getDataNodeService() {
                return new DataNodeService("_default_tier", 0L, ServerType.INDEXER_EXECUTOR, 0);
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceInputSourceModule(), (Object)new IndexingServiceTaskLogsModule(), (Object)new IndexingServiceTuningConfigModule(), (Object)new QueryablePeonModule(), (Object)new CliIndexerServerModule(this.properties), (Object)new LookupModule());
    }
}

