/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.List;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.IndexingServiceTaskLogsModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.HadoopTask;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.server.DruidNode;
import org.apache.druid.tasklogs.TaskLogKiller;

@Command(name="reset-cluster", description="Cleanup all persisted state from metadata and deep storage.")
public class ResetCluster
extends GuiceRunnable {
    private static final Logger log = new Logger(ResetCluster.class);
    @Option(name={"--all"}, description="delete all state stored in metadata and deep storage")
    private boolean all;
    @Option(name={"--metadataStore"}, description="delete all records in metadata storage")
    private boolean metadataStore;
    @Option(name={"--segmentFiles"}, description="delete all segment files from deep storage")
    private boolean segmentFiles;
    @Option(name={"--taskLogs"}, description="delete all tasklogs")
    private boolean taskLogs;
    @Option(name={"--hadoopWorkingPath"}, description="delete hadoopWorkingPath")
    private boolean hadoopWorkingPath;

    public ResetCluster() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("tools", "localhost", false, Integer.valueOf(-1), null, true, false));
            JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
        }, (Object)new IndexingServiceTaskLogsModule());
    }

    @Override
    public void run() {
        if (this.all) {
            this.hadoopWorkingPath = true;
            this.taskLogs = true;
            this.segmentFiles = true;
            this.metadataStore = true;
        }
        Injector injector = this.makeInjector();
        if (this.metadataStore) {
            this.resetMetadataStore(injector);
        }
        if (this.segmentFiles) {
            this.deleteAllSegmentFiles(injector);
        }
        if (this.taskLogs) {
            this.deleteAllTaskLogs(injector);
        }
        if (this.hadoopWorkingPath) {
            this.deleteIndexerHadoopWorkingDir(injector);
        }
    }

    private void resetMetadataStore(Injector injector) {
        String[] tables;
        log.info("===========================================================================", new Object[0]);
        log.info("Deleting all Records from Metadata Storage.", new Object[0]);
        log.info("===========================================================================", new Object[0]);
        MetadataStorageConnector connector = (MetadataStorageConnector)injector.getInstance(MetadataStorageConnector.class);
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)injector.getInstance(MetadataStorageTablesConfig.class);
        for (String table : tables = new String[]{tablesConfig.getDataSourceTable(), tablesConfig.getPendingSegmentsTable(), tablesConfig.getSegmentsTable(), tablesConfig.getRulesTable(), tablesConfig.getConfigTable(), tablesConfig.getTasksTable(), tablesConfig.getTaskLockTable(), tablesConfig.getTaskLogTable(), tablesConfig.getAuditTable(), tablesConfig.getSupervisorTable()}) {
            connector.deleteAllRecords(table);
        }
    }

    private void deleteAllSegmentFiles(Injector injector) {
        try {
            log.info("===========================================================================", new Object[0]);
            log.info("Deleting all Segment Files.", new Object[0]);
            log.info("===========================================================================", new Object[0]);
            DataSegmentKiller segmentKiller = (DataSegmentKiller)injector.getInstance(DataSegmentKiller.class);
            segmentKiller.killAll();
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Failed to cleanup Segment Files.", new Object[0]);
        }
    }

    private void deleteAllTaskLogs(Injector injector) {
        try {
            log.info("===========================================================================", new Object[0]);
            log.info("Deleting all TaskLogs.", new Object[0]);
            log.info("===========================================================================", new Object[0]);
            TaskLogKiller taskLogKiller = (TaskLogKiller)injector.getInstance(TaskLogKiller.class);
            taskLogKiller.killAll();
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Failed to cleanup TaskLogs.", new Object[0]);
        }
    }

    private void deleteIndexerHadoopWorkingDir(Injector injector) {
        try {
            log.info("===========================================================================", new Object[0]);
            log.info("Deleting hadoopWorkingPath.", new Object[0]);
            log.info("===========================================================================", new Object[0]);
            TaskConfig taskConfig = (TaskConfig)injector.getInstance(TaskConfig.class);
            HadoopTask.invokeForeignLoader((String)"org.apache.druid.indexer.HadoopWorkingDirCleaner", (Object)new String[]{taskConfig.getHadoopWorkingPath()}, (ClassLoader)HadoopTask.buildClassLoader(null, (List)taskConfig.getDefaultHadoopCoordinates()));
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Failed to cleanup indexer hadoop working directory.", new Object[0]);
        }
    }
}

