/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.druid.cli.WebConsoleJettyServerInitializer;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.server.AsyncManagementForwardingServlet;
import org.apache.druid.server.AsyncQueryForwardingServlet;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.router.ManagementProxyConfig;
import org.apache.druid.server.router.Router;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class RouterJettyServerInitializer
implements JettyServerInitializer {
    private static final List<String> UNSECURED_PATHS = ImmutableList.of((Object)"/status/health", (Object)"/druid/v2/sql/avatica/");
    private final DruidHttpClientConfig routerHttpClientConfig;
    private final DruidHttpClientConfig globalHttpClientConfig;
    private final ManagementProxyConfig managementProxyConfig;
    private final AsyncQueryForwardingServlet asyncQueryForwardingServlet;
    private final AsyncManagementForwardingServlet asyncManagementForwardingServlet;
    private final AuthConfig authConfig;
    private final ServerConfig serverConfig;

    @Inject
    public RouterJettyServerInitializer(@Router DruidHttpClientConfig routerHttpClientConfig, @Global DruidHttpClientConfig globalHttpClientConfig, ManagementProxyConfig managementProxyConfig, AsyncQueryForwardingServlet asyncQueryForwardingServlet, AsyncManagementForwardingServlet asyncManagementForwardingServlet, AuthConfig authConfig, ServerConfig serverConfig) {
        this.routerHttpClientConfig = routerHttpClientConfig;
        this.globalHttpClientConfig = globalHttpClientConfig;
        this.managementProxyConfig = managementProxyConfig;
        this.asyncQueryForwardingServlet = asyncQueryForwardingServlet;
        this.asyncManagementForwardingServlet = asyncManagementForwardingServlet;
        this.authConfig = authConfig;
        this.serverConfig = serverConfig;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        ServletHolder queryServletHolder = this.buildServletHolder((Servlet)this.asyncQueryForwardingServlet, this.routerHttpClientConfig);
        root.addServlet(queryServletHolder, "/druid/v2/*");
        root.addServlet(queryServletHolder, "/druid/v1/lookups/*");
        if (this.managementProxyConfig.isEnabled()) {
            ServletHolder managementForwardingServletHolder = this.buildServletHolder((Servlet)this.asyncManagementForwardingServlet, this.globalHttpClientConfig);
            root.addServlet(managementForwardingServletHolder, "/druid/coordinator/*");
            root.addServlet(managementForwardingServletHolder, "/druid/indexer/*");
            root.addServlet(managementForwardingServletHolder, "/proxy/*");
        }
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        WebConsoleJettyServerInitializer.intializeServerForWebConsoleRoot(root);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, (List)this.authConfig.getUnsecuredPaths());
        List authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)this.authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(GuiceFilter.class, "/druid/router/*", null);
        root.addFilter(GuiceFilter.class, "/druid-ext/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{WebConsoleJettyServerInitializer.createWebConsoleRewriteHandler(), JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel())});
        server.setHandler((Handler)handlerList);
    }

    private ServletHolder buildServletHolder(Servlet servlet, DruidHttpClientConfig httpClientConfig) {
        ServletHolder sh = new ServletHolder(servlet);
        sh.setInitParameter("maxThreads", Integer.toString(httpClientConfig.getNumMaxThreads()));
        sh.setInitParameter("maxConnections", Integer.toString(httpClientConfig.getNumConnections()));
        sh.setInitParameter("idleTimeout", Long.toString(httpClientConfig.getReadTimeout().getMillis()));
        sh.setInitParameter("timeout", Long.toString(httpClientConfig.getReadTimeout().getMillis()));
        return sh;
    }
}

