/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.cli.MiddleManagerJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.indexing.HttpIndexingServiceClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.discovery.WorkerNodeService;
import org.apache.druid.guice.IndexingServiceFirehoseModule;
import org.apache.druid.guice.IndexingServiceInputSourceModule;
import org.apache.druid.guice.IndexingServiceModuleHelper;
import org.apache.druid.guice.IndexingServiceTaskLogsModule;
import org.apache.druid.guice.IndexingServiceTuningConfigModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.overlord.ForkingTaskRunner;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.indexing.worker.WorkerCuratorCoordinator;
import org.apache.druid.indexing.worker.WorkerTaskMonitor;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.http.ShuffleResource;
import org.apache.druid.indexing.worker.http.TaskManagementResource;
import org.apache.druid.indexing.worker.http.WorkerResource;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.DummyForInjectionAppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.timeline.PruneLastCompactionState;
import org.eclipse.jetty.server.Server;

@Command(name="middleManager", description="Runs a Middle Manager, this is a \"task\" node used as part of the remote indexing service, see https://druid.apache.org/docs/latest/design/middlemanager.html for a description")
public class CliMiddleManager
extends ServerRunnable {
    private static final Logger log = new Logger(CliMiddleManager.class);

    public CliMiddleManager() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/middlemanager");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8091);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8291);
                binder.bindConstant().annotatedWith(PruneLastCompactionState.class).to(true);
                IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                binder.bind(TaskRunner.class).to(ForkingTaskRunner.class);
                binder.bind(ForkingTaskRunner.class).in(LazySingleton.class);
                binder.bind(IndexingServiceClient.class).to(HttpIndexingServiceClient.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<IndexTaskClientFactory<ParallelIndexSupervisorTaskClient>>(){}).toProvider(Providers.of(null));
                binder.bind(ShuffleClient.class).toProvider(Providers.of(null));
                binder.bind(ChatHandlerProvider.class).toProvider(Providers.of(null));
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.rowIngestionMeters.type", (Key)Key.get(RowIngestionMetersFactory.class), (Key)Key.get(DropwizardRowIngestionMetersFactory.class));
                MapBinder rowIngestionMetersHandlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(RowIngestionMetersFactory.class));
                rowIngestionMetersHandlerProviderBinder.addBinding((Object)"dropwizard").to(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
                binder.bind(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
                CliMiddleManager.bindWorkerManagementClasses(binder);
                binder.bind(JettyServerInitializer.class).to(MiddleManagerJettyServerInitializer.class).in(LazySingleton.class);
                binder.bind(AppenderatorsManager.class).to(DummyForInjectionAppenderatorsManager.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, ShuffleResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                ServerRunnable.bindNodeRoleAndAnnouncer(binder, ServerRunnable.DiscoverySideEffectsProvider.builder(NodeRole.MIDDLE_MANAGER).serviceClasses((List<Class<? extends DruidService>>)ImmutableList.of(WorkerNodeService.class)).build());
                Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
            }

            @Provides
            @LazySingleton
            public Worker getWorker(@Self DruidNode node, WorkerConfig config) {
                return new Worker(node.getServiceScheme(), node.getHostAndPortToUse(), config.getIp(), config.getCapacity(), config.getVersion(), config.getCategory());
            }

            @Provides
            @LazySingleton
            public WorkerNodeService getWorkerNodeService(WorkerConfig workerConfig) {
                return new WorkerNodeService(workerConfig.getIp(), workerConfig.getCapacity(), workerConfig.getVersion(), workerConfig.getCategory());
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceInputSourceModule(), (Object)new IndexingServiceTaskLogsModule(), (Object)new IndexingServiceTuningConfigModule(), (Object)new InputSourceModule(), (Object)new LookupSerdeModule());
    }

    public static void bindWorkerManagementClasses(Binder binder) {
        binder.bind(WorkerTaskMonitor.class).in(ManageLifecycle.class);
        binder.bind(WorkerCuratorCoordinator.class).in(ManageLifecycle.class);
        LifecycleModule.register((Binder)binder, WorkerTaskMonitor.class);
        Jerseys.addResource((Binder)binder, WorkerResource.class);
        Jerseys.addResource((Binder)binder, TaskManagementResource.class);
    }
}

