/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.DruidNode;

public abstract class ServerRunnable
extends GuiceRunnable {
    private static final EmittingLogger log = new EmittingLogger(ServerRunnable.class);

    public ServerRunnable(Logger log) {
        super(log);
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        Lifecycle lifecycle = this.initLifecycle(injector);
        try {
            lifecycle.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void bindNodeRoleAndAnnouncer(Binder binder, DiscoverySideEffectsProvider discoverySideEffectsProvider) {
        Multibinder selfBinder = Multibinder.newSetBinder((Binder)binder, NodeRole.class, Self.class);
        selfBinder.addBinding().toInstance((Object)discoverySideEffectsProvider.nodeRole);
        ServerRunnable.bindAnnouncer(binder, discoverySideEffectsProvider);
    }

    public static void bindNodeRoleAndAnnouncer(Binder binder, Class<? extends Annotation> annotation, DiscoverySideEffectsProvider discoverySideEffectsProvider) {
        Multibinder selfBinder = Multibinder.newSetBinder((Binder)binder, NodeRole.class, Self.class);
        selfBinder.addBinding().toInstance((Object)discoverySideEffectsProvider.nodeRole);
        ServerRunnable.bindAnnouncer(binder, annotation, discoverySideEffectsProvider);
    }

    private static void bindAnnouncer(Binder binder, DiscoverySideEffectsProvider provider) {
        binder.bind(DiscoverySideEffectsProvider.Child.class).toProvider((Provider)provider).in(LazySingleton.class);
        LifecycleModule.registerKey((Binder)binder, (Key)Key.get(DiscoverySideEffectsProvider.Child.class));
    }

    private static void bindAnnouncer(Binder binder, Class<? extends Annotation> annotation, DiscoverySideEffectsProvider provider) {
        binder.bind(DiscoverySideEffectsProvider.Child.class).annotatedWith(annotation).toProvider((Provider)provider).in(LazySingleton.class);
        LifecycleModule.registerKey((Binder)binder, (Key)Key.get(DiscoverySideEffectsProvider.Child.class, annotation));
    }

    public static class DiscoverySideEffectsProvider
    implements Provider<Child> {
        @Inject
        @Self
        private DruidNode druidNode;
        @Inject
        private DruidNodeAnnouncer announcer;
        @Inject
        private ServiceAnnouncer legacyAnnouncer;
        @Inject
        private Lifecycle lifecycle;
        @Inject
        private Injector injector;
        private final NodeRole nodeRole;
        private final List<Class<? extends DruidService>> serviceClasses;
        private final boolean useLegacyAnnouncer;

        public static Builder builder(NodeRole nodeRole) {
            return new Builder(nodeRole);
        }

        private DiscoverySideEffectsProvider(NodeRole nodeRole, List<Class<? extends DruidService>> serviceClasses, boolean useLegacyAnnouncer) {
            this.nodeRole = nodeRole;
            this.serviceClasses = serviceClasses;
            this.useLegacyAnnouncer = useLegacyAnnouncer;
        }

        @VisibleForTesting
        DiscoverySideEffectsProvider(NodeRole nodeRole, List<Class<? extends DruidService>> serviceClasses, boolean useLegacyAnnouncer, DruidNode druidNode, DruidNodeAnnouncer announcer, ServiceAnnouncer legacyAnnouncer, Lifecycle lifecycle, Injector injector) {
            this.nodeRole = nodeRole;
            this.serviceClasses = serviceClasses;
            this.useLegacyAnnouncer = useLegacyAnnouncer;
            this.druidNode = druidNode;
            this.announcer = announcer;
            this.legacyAnnouncer = legacyAnnouncer;
            this.lifecycle = lifecycle;
            this.injector = injector;
        }

        public Child get() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Class<? extends DruidService> clazz : this.serviceClasses) {
                DruidService service = (DruidService)this.injector.getInstance(clazz);
                if (service.isDiscoverable()) {
                    builder.put((Object)service.getName(), (Object)service);
                    continue;
                }
                log.info("Service[%s] is not discoverable. This will not be listed as a service provided by this node.", new Object[]{service.getName()});
            }
            final DiscoveryDruidNode discoveryDruidNode = new DiscoveryDruidNode(this.druidNode, this.nodeRole, (Map)builder.build());
            this.lifecycle.addHandler(new Lifecycle.Handler(){

                public void start() {
                    announcer.announce(discoveryDruidNode);
                    if (useLegacyAnnouncer) {
                        legacyAnnouncer.announce(discoveryDruidNode.getDruidNode());
                    }
                }

                public void stop() {
                    if (useLegacyAnnouncer) {
                        legacyAnnouncer.unannounce(discoveryDruidNode.getDruidNode());
                    }
                    announcer.unannounce(discoveryDruidNode);
                }
            }, Lifecycle.Stage.ANNOUNCEMENTS);
            return new Child();
        }

        public static class Builder {
            private NodeRole nodeRole;
            private List<Class<? extends DruidService>> serviceClasses = ImmutableList.of();
            private boolean useLegacyAnnouncer;

            public Builder(NodeRole nodeRole) {
                this.nodeRole = nodeRole;
            }

            public Builder serviceClasses(List<Class<? extends DruidService>> serviceClasses) {
                this.serviceClasses = serviceClasses;
                return this;
            }

            public Builder useLegacyAnnouncer(boolean useLegacyAnnouncer) {
                this.useLegacyAnnouncer = useLegacyAnnouncer;
                return this;
            }

            public DiscoverySideEffectsProvider build() {
                return new DiscoverySideEffectsProvider(this.nodeRole, this.serviceClasses, this.useLegacyAnnouncer);
            }
        }

        public static class Child {
        }
    }
}

