/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.router;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.server.router.TieredBrokerConfig;
import org.apache.druid.server.router.TieredBrokerSelectorStrategy;
import org.apache.druid.sql.http.SqlQuery;

public class ManualTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private static final Logger log = new Logger(ManualTieredBrokerSelectorStrategy.class);
    private final String defaultManualBrokerService;

    @JsonCreator
    public ManualTieredBrokerSelectorStrategy(@JsonProperty(value="defaultManualBrokerService") @Nullable String defaultManualBrokerService) {
        this.defaultManualBrokerService = defaultManualBrokerService;
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig tierConfig, Query query) {
        return this.getBrokerServiceName(tierConfig, query.getContext());
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig config, SqlQuery sqlQuery) {
        return this.getBrokerServiceName(config, sqlQuery.getContext());
    }

    private Optional<String> getBrokerServiceName(TieredBrokerConfig tierConfig, Map<String, Object> queryContext) {
        try {
            String contextBrokerService = QueryContexts.getBrokerServiceName(queryContext);
            if (this.isValidBrokerService(contextBrokerService, tierConfig)) {
                return Optional.of((Object)contextBrokerService);
            }
            if (this.isValidBrokerService(this.defaultManualBrokerService, tierConfig)) {
                return Optional.of((Object)this.defaultManualBrokerService);
            }
            log.warn("Could not find Broker Service [%s] or default [%s] in TieredBrokerConfig", new Object[]{contextBrokerService, this.defaultManualBrokerService});
            return Optional.absent();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error getting Broker Service name from Query Context", new Object[0]);
            return this.isValidBrokerService(this.defaultManualBrokerService, tierConfig) ? Optional.of((Object)this.defaultManualBrokerService) : Optional.absent();
        }
    }

    private boolean isValidBrokerService(String brokerServiceName, TieredBrokerConfig tierConfig) {
        return !StringUtils.isEmpty((String)brokerServiceName) && tierConfig.getTierToBrokerMap().containsValue(brokerServiceName);
    }

    @VisibleForTesting
    String getDefaultManualBrokerService() {
        return this.defaultManualBrokerService;
    }
}

