/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.netty.util.SuppressForbidden;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.nested.CompressedNestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedFieldDictionaryEncodedColumn;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

@Command(name="dump-segment", description="Dump segment data")
public class DumpSegment
extends GuiceRunnable {
    private static final Logger log = new Logger(DumpSegment.class);
    @Option(name={"-d", "--directory"}, title={"directory"}, description="Directory containing segment data.")
    @Required
    public String directory;
    @Option(name={"-o", "--out"}, title={"file"}, description="File to write to, or omit to write to stdout.")
    public String outputFileName;
    @Option(name={"--filter"}, title={"json"}, description="Filter, JSON encoded, or omit to include all rows. Only used if dumping rows.")
    public String filterJson = null;
    @Option(name={"-c", "--column"}, title={"column"}, description="Column to include, specify multiple times for multiple columns, or omit to include all columns.")
    public List<String> columnNamesFromCli = new ArrayList<String>();
    @Option(name={"--nested-path"}, title={"nested path"}, description="JSONPath expression for nested column")
    public String nestedPath;
    @Option(name={"--time-iso8601"}, title={"Format __time column in ISO8601 format rather than long. Only used if dumping rows."})
    public boolean timeISO8601 = false;
    @Option(name={"--dump"}, title={"type"}, description="Dump either 'rows' (default), 'metadata', or 'bitmaps'")
    public String dumpTypeString = DumpType.ROWS.toString();
    @Option(name={"--decompress-bitmaps"}, title={"Dump bitmaps as arrays rather than base64-encoded compressed bitmaps. Only used if dumping bitmaps."})
    public boolean decompressBitmaps = false;

    public DumpSegment() {
        super(log);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        DumpType dumpType;
        Injector injector = this.makeInjector();
        IndexIO indexIO = (IndexIO)injector.getInstance(IndexIO.class);
        try {
            dumpType = DumpType.valueOf(StringUtils.toUpperCase((String)this.dumpTypeString));
        }
        catch (Exception e) {
            throw new IAE("Not a valid dump type: %s", new Object[]{this.dumpTypeString});
        }
        try (QueryableIndex index = indexIO.loadIndex(new File(this.directory));){
            switch (dumpType) {
                case ROWS: {
                    this.runDump(injector, index);
                    return;
                }
                case METADATA: {
                    this.runMetadata(injector, index);
                    return;
                }
                case BITMAPS: {
                    DumpSegment.runBitmaps(injector, this.outputFileName, index, this.getColumnsToInclude(index), this.decompressBitmaps);
                    return;
                }
                case NESTED: {
                    Preconditions.checkArgument((this.columnNamesFromCli.size() == 1 ? 1 : 0) != 0, (Object)"Must be exactly 1 column specified");
                    String nestedColumn = this.columnNamesFromCli.get(0);
                    if (this.nestedPath == null) {
                        DumpSegment.runDumpNestedColumn(injector, this.outputFileName, index, nestedColumn);
                        return;
                    } else {
                        DumpSegment.runDumpNestedColumnPath(injector, this.outputFileName, index, nestedColumn, this.nestedPath);
                        return;
                    }
                }
                default: {
                    throw new ISE("dumpType[%s] has no handler", new Object[]{dumpType});
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void runMetadata(final Injector injector, final QueryableIndex index) throws IOException {
        final ObjectMapper objectMapper = ((ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class))).copy().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        final SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new TableDataSource("dataSource"), (QuerySegmentSpec)new SpecificSegmentSpec(new SegmentDescriptor(index.getDataInterval(), "0", 0)), (ColumnIncluderator)new ListColumnIncluderator(this.getColumnsToInclude(index)), Boolean.valueOf(false), null, EnumSet.allOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        this.withOutputStream(new Function<OutputStream, Object>(){

            public Object apply(final OutputStream out) {
                DumpSegment.evaluateSequenceForSideEffects(Sequences.map(DumpSegment.executeQuery(injector, index, query), (Function)new Function<SegmentAnalysis, Object>(){

                    public Object apply(SegmentAnalysis analysis) {
                        try {
                            objectMapper.writeValue(out, (Object)analysis);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                }));
                return null;
            }
        });
    }

    private void runDump(Injector injector, QueryableIndex index) throws IOException {
        final ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        QueryableIndexStorageAdapter adapter = new QueryableIndexStorageAdapter(index);
        final List<String> columnNames = this.getColumnsToInclude(index);
        DimFilter filter = this.filterJson != null ? (DimFilter)objectMapper.readValue(this.filterJson, DimFilter.class) : null;
        final Sequence cursors = adapter.makeCursors(Filters.toFilter(filter), index.getDataInterval().withChronology((Chronology)ISOChronology.getInstanceUTC()), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        this.withOutputStream(new Function<OutputStream, Object>(){

            public Object apply(final OutputStream out) {
                Sequence sequence = Sequences.map((Sequence)cursors, (Function)new Function<Cursor, Object>(){

                    public Object apply(Cursor cursor) {
                        ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                        List selectors = columnNames.stream().map(arg_0 -> ((ColumnSelectorFactory)columnSelectorFactory).makeColumnValueSelector(arg_0)).collect(Collectors.toList());
                        while (!cursor.isDone()) {
                            LinkedHashMap row = Maps.newLinkedHashMap();
                            for (int i = 0; i < columnNames.size(); ++i) {
                                String columnName = (String)columnNames.get(i);
                                Object value = ((BaseObjectColumnValueSelector)selectors.get(i)).getObject();
                                if (DumpSegment.this.timeISO8601 && ((String)columnNames.get(i)).equals("__time")) {
                                    row.put(columnName, new DateTime(value, DateTimeZone.UTC).toString());
                                    continue;
                                }
                                row.put(columnName, value);
                            }
                            try {
                                out.write(objectMapper.writeValueAsBytes((Object)row));
                                out.write(10);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            cursor.advance();
                        }
                        return null;
                    }
                });
                DumpSegment.evaluateSequenceForSideEffects(sequence);
                return null;
            }
        });
    }

    @VisibleForTesting
    public static void runBitmaps(Injector injector, String outputFileName, QueryableIndex index, List<String> columnNames, boolean decompressBitmaps) throws IOException {
        ConciseBitmapSerdeFactory bitmapSerdeFactory;
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
        if (bitmapFactory instanceof ConciseBitmapFactory) {
            bitmapSerdeFactory = new ConciseBitmapSerdeFactory();
        } else if (bitmapFactory instanceof RoaringBitmapFactory) {
            bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
        } else {
            throw new ISE("Don't know which BitmapSerdeFactory to use for BitmapFactory[%s]!", new Object[]{bitmapFactory.getClass().getName()});
        }
        DumpSegment.withOutputStream(arg_0 -> DumpSegment.lambda$runBitmaps$0(objectMapper, (BitmapSerdeFactory)bitmapSerdeFactory, columnNames, index, decompressBitmaps, arg_0), outputFileName);
    }

    @VisibleForTesting
    public static void runDumpNestedColumn(Injector injector, String outputFileName, QueryableIndex index, String columnName) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        DumpSegment.withOutputStream(out -> {
            try (JsonGenerator jg = objectMapper.getFactory().createGenerator(out);){
                jg.writeStartObject();
                jg.writeFieldName(columnName);
                jg.writeStartObject();
                ColumnHolder columnHolder = index.getColumnHolder(columnName);
                BaseColumn baseColumn = columnHolder.getColumn();
                Preconditions.checkArgument((boolean)(baseColumn instanceof CompressedNestedDataComplexColumn));
                CompressedNestedDataComplexColumn nestedDataColumn = (CompressedNestedDataComplexColumn)baseColumn;
                jg.writeFieldName("fields");
                jg.writeStartArray();
                List fields = nestedDataColumn.getNestedFields();
                for (List field : fields) {
                    jg.writeStartObject();
                    jg.writeFieldName("path");
                    jg.writeString(NestedPathFinder.toNormalizedJsonPath((List)field));
                    jg.writeFieldName("types");
                    Set types = nestedDataColumn.getColumnTypes(field);
                    jg.writeStartArray();
                    for (ColumnType type : types) {
                        jg.writeString(type.asTypeString());
                    }
                    jg.writeEndArray();
                    jg.writeEndObject();
                }
                jg.writeEndArray();
                Indexed globalStringDictionary = nestedDataColumn.getUtf8BytesDictionary();
                Indexed globalLongDictionary = nestedDataColumn.getLongDictionary();
                Indexed globalDoubleDictionary = nestedDataColumn.getDoubleDictionary();
                jg.writeFieldName("dictionaries");
                jg.writeStartObject();
                int globalId = 0;
                jg.writeFieldName("strings");
                jg.writeStartArray();
                int i = 0;
                while (i < globalStringDictionary.size()) {
                    jg.writeStartObject();
                    jg.writeFieldName("globalId");
                    jg.writeNumber(globalId);
                    jg.writeFieldName("value");
                    ByteBuffer val = (ByteBuffer)globalStringDictionary.get(i);
                    if (val == null) {
                        jg.writeNull();
                    } else {
                        jg.writeString(StringUtils.fromUtf8((ByteBuffer)val));
                    }
                    jg.writeEndObject();
                    ++i;
                    ++globalId;
                }
                jg.writeEndArray();
                jg.writeFieldName("longs");
                jg.writeStartArray();
                i = 0;
                while (i < globalLongDictionary.size()) {
                    jg.writeStartObject();
                    jg.writeFieldName("globalId");
                    jg.writeNumber(globalId);
                    jg.writeFieldName("value");
                    jg.writeNumber(((Long)globalLongDictionary.get(i)).longValue());
                    jg.writeEndObject();
                    ++i;
                    ++globalId;
                }
                jg.writeEndArray();
                jg.writeFieldName("doubles");
                jg.writeStartArray();
                i = 0;
                while (i < globalDoubleDictionary.size()) {
                    jg.writeStartObject();
                    jg.writeFieldName("globalId");
                    jg.writeNumber(globalId);
                    jg.writeFieldName("value");
                    jg.writeNumber(((Double)globalDoubleDictionary.get(i)).doubleValue());
                    jg.writeEndObject();
                    ++i;
                    ++globalId;
                }
                jg.writeEndArray();
                jg.writeFieldName("nullRows");
                ImmutableBitmap bitmap = nestedDataColumn.getNullValues();
                jg.writeStartArray();
                for (int rowNum : bitmap) {
                    jg.writeNumber(rowNum);
                }
                jg.writeEndArray();
                jg.writeEndObject();
                jg.writeEndObject();
                jg.writeEndObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        }, outputFileName);
    }

    @VisibleForTesting
    public static void runDumpNestedColumnPath(Injector injector, String outputFileName, QueryableIndex index, String columnName, String path) throws IOException {
        ConciseBitmapSerdeFactory bitmapSerdeFactory;
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        SerializerProvider serializers = objectMapper.getSerializerProviderInstance();
        BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
        if (bitmapFactory instanceof ConciseBitmapFactory) {
            bitmapSerdeFactory = new ConciseBitmapSerdeFactory();
        } else if (bitmapFactory instanceof RoaringBitmapFactory) {
            bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
        } else {
            throw new ISE("Don't know which BitmapSerdeFactory to use for BitmapFactory[%s]!", new Object[]{bitmapFactory.getClass().getName()});
        }
        DumpSegment.withOutputStream(arg_0 -> DumpSegment.lambda$runDumpNestedColumnPath$2(objectMapper, (BitmapSerdeFactory)bitmapSerdeFactory, columnName, index, path, serializers, arg_0), outputFileName);
    }

    private List<String> getColumnsToInclude(QueryableIndex index) {
        LinkedHashSet columnNames = Sets.newLinkedHashSet(this.columnNamesFromCli);
        if (columnNames.isEmpty()) {
            columnNames.add("__time");
            Iterables.addAll((Collection)columnNames, (Iterable)index.getColumnNames());
        } else {
            for (String columnName : ImmutableList.copyOf((Collection)columnNames)) {
                if (index.getColumnHolder(columnName) != null) continue;
                columnNames.remove(columnName);
            }
        }
        return ImmutableList.copyOf((Collection)columnNames);
    }

    private <T> T withOutputStream(Function<OutputStream, T> f) throws IOException {
        return DumpSegment.withOutputStream(f, this.outputFileName);
    }

    @SuppressForbidden(reason="System#out")
    private static <T> T withOutputStream(Function<OutputStream, T> f, String outputFileName) throws IOException {
        if (outputFileName == null) {
            return (T)f.apply((Object)System.out);
        }
        try (FileOutputStream out = new FileOutputStream(outputFileName);){
            Object object = f.apply((Object)out);
            return (T)object;
        }
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/tool");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(9999);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
        });
    }

    @VisibleForTesting
    static <T> Sequence<T> executeQuery(Injector injector, QueryableIndex index, Query<T> query) {
        QueryRunnerFactoryConglomerate conglomerate = (QueryRunnerFactoryConglomerate)injector.getInstance(QueryRunnerFactoryConglomerate.class);
        QueryRunnerFactory factory = conglomerate.findFactory(query);
        QueryRunner runner = factory.createRunner((Segment)new QueryableIndexSegment(index, SegmentId.dummy((String)"segment")));
        return factory.getToolchest().mergeResults(factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)ImmutableList.of((Object)runner))).run(QueryPlus.wrap(query), ResponseContext.createEmpty());
    }

    private static <T> void evaluateSequenceForSideEffects(Sequence<T> sequence) {
        sequence.accumulate(null, (accumulated, in) -> null);
    }

    private static /* synthetic */ Object lambda$runDumpNestedColumnPath$2(ObjectMapper objectMapper, BitmapSerdeFactory bitmapSerdeFactory, String columnName, QueryableIndex index, String path, SerializerProvider serializers, OutputStream out) {
        try (JsonGenerator jg = objectMapper.getFactory().createGenerator(out);){
            jg.writeStartObject();
            jg.writeObjectField("bitmapSerdeFactory", (Object)bitmapSerdeFactory);
            jg.writeFieldName(columnName);
            jg.writeStartObject();
            ColumnHolder columnHolder = index.getColumnHolder(columnName);
            BaseColumn column = columnHolder.getColumn();
            Preconditions.checkArgument((boolean)(column instanceof CompressedNestedDataComplexColumn));
            CompressedNestedDataComplexColumn nestedDataColumn = (CompressedNestedDataComplexColumn)column;
            List pathParts = NestedPathFinder.parseJsonPath((String)path);
            ColumnIndexSupplier indexSupplier = nestedDataColumn.getColumnIndexSupplier(pathParts);
            ColumnHolder nestedPathColumnHolder = nestedDataColumn.getColumnHolder(pathParts);
            NestedFieldDictionaryEncodedColumn nestedPathColumn = (NestedFieldDictionaryEncodedColumn)nestedPathColumnHolder.getColumn();
            FixedIndexed nestedPathDictionary = nestedPathColumn.getDictionary();
            SimpleAscendingOffset offset = new SimpleAscendingOffset(index.getNumRows());
            ColumnValueSelector rawSelector = nestedDataColumn.makeColumnValueSelector((ReadableOffset)offset);
            DimensionSelector fieldSelector = nestedDataColumn.makeDimensionSelector(pathParts, (ReadableOffset)offset, null);
            if (indexSupplier == null) {
                jg.writeNullField(path);
            } else {
                DictionaryEncodedStringValueIndex valueIndex = (DictionaryEncodedStringValueIndex)indexSupplier.as(DictionaryEncodedStringValueIndex.class);
                if (valueIndex == null) {
                    jg.writeNullField(path);
                } else {
                    int i;
                    jg.writeFieldName(path);
                    jg.writeStartObject();
                    jg.writeFieldName("types");
                    Set types = nestedDataColumn.getColumnTypes(pathParts);
                    jg.writeStartArray();
                    for (ColumnType type : types) {
                        jg.writeString(type.asTypeString());
                    }
                    jg.writeEndArray();
                    jg.writeFieldName("dictionary");
                    jg.writeStartArray();
                    for (i = 0; i < valueIndex.getCardinality(); ++i) {
                        jg.writeStartObject();
                        jg.writeFieldName("localId");
                        jg.writeNumber(i);
                        jg.writeFieldName("globalId");
                        jg.writeNumber(((Integer)nestedPathDictionary.get(i)).intValue());
                        jg.writeFieldName("value");
                        String val = valueIndex.getValue(i);
                        if (val == null) {
                            jg.writeNull();
                        } else {
                            jg.writeString(val);
                        }
                        jg.writeFieldName("rows");
                        ImmutableBitmap bitmap = valueIndex.getBitmap(i);
                        jg.writeStartArray();
                        for (int rowNum : bitmap) {
                            jg.writeNumber(rowNum);
                        }
                        jg.writeEndArray();
                        jg.writeEndObject();
                    }
                    jg.writeEndArray();
                    jg.writeFieldName("column");
                    jg.writeStartArray();
                    for (i = 0; i < index.getNumRows(); ++i) {
                        jg.writeStartObject();
                        jg.writeFieldName("row");
                        jg.writeNumber(i);
                        jg.writeFieldName("raw");
                        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)rawSelector.getObject());
                        jg.writeFieldName("fieldId");
                        int id = fieldSelector.getRow().get(0);
                        jg.writeNumber(id);
                        jg.writeFieldName("fieldValue");
                        String val = fieldSelector.lookupName(id);
                        if (val == null) {
                            jg.writeNull();
                        } else {
                            jg.writeString(val);
                        }
                        jg.writeEndObject();
                        offset.increment();
                    }
                    jg.writeEndArray();
                    jg.writeEndObject();
                }
            }
            column.close();
            jg.writeEndObject();
            jg.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static /* synthetic */ Object lambda$runBitmaps$0(ObjectMapper objectMapper, BitmapSerdeFactory bitmapSerdeFactory, List columnNames, QueryableIndex index, boolean decompressBitmaps, OutputStream out) {
        try (JsonGenerator jg = objectMapper.getFactory().createGenerator(out);){
            jg.writeStartObject();
            jg.writeObjectField("bitmapSerdeFactory", (Object)bitmapSerdeFactory);
            jg.writeFieldName("bitmaps");
            jg.writeStartObject();
            for (String columnName : columnNames) {
                ColumnHolder columnHolder = index.getColumnHolder(columnName);
                ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
                if (indexSupplier == null) {
                    jg.writeNullField(columnName);
                    continue;
                }
                DictionaryEncodedStringValueIndex valueIndex = (DictionaryEncodedStringValueIndex)indexSupplier.as(DictionaryEncodedStringValueIndex.class);
                if (valueIndex == null) {
                    jg.writeNullField(columnName);
                    continue;
                }
                jg.writeFieldName(columnName);
                jg.writeStartObject();
                for (int i = 0; i < valueIndex.getCardinality(); ++i) {
                    String val = valueIndex.getValue(i);
                    jg.writeFieldName(val == null ? "null" : val);
                    ImmutableBitmap bitmap = valueIndex.getBitmap(i);
                    if (decompressBitmaps) {
                        jg.writeStartArray();
                        for (int rowNum : bitmap) {
                            jg.writeNumber(rowNum);
                        }
                        jg.writeEndArray();
                        continue;
                    }
                    byte[] bytes = bitmapSerdeFactory.getObjectStrategy().toBytes((Object)bitmap);
                    if (bytes == null) continue;
                    jg.writeBinary(bytes);
                }
                jg.writeEndObject();
            }
            jg.writeEndObject();
            jg.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static enum DumpType {
        ROWS,
        METADATA,
        BITMAPS,
        NESTED;

    }
}

