/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.ambari.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.druid.emitter.ambari.metrics.DruidToTimelineMetricConverter;

public class AmbariMetricsEmitterConfig {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final long DEFAULT_FLUSH_PERIOD_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_GET_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final String DEFAULT_PROTOCOL = "http";
    @JsonProperty
    private final String hostname;
    @JsonProperty
    private final int port;
    @JsonProperty
    private final String protocol;
    @JsonProperty
    private final String trustStorePath;
    @JsonProperty
    private final String trustStoreType;
    @JsonProperty
    private final String trustStorePassword;
    @JsonProperty
    private final int batchSize;
    @JsonProperty
    private final long flushPeriod;
    @JsonProperty
    private final int maxQueueSize;
    @JsonProperty(value="eventConverter")
    private final DruidToTimelineMetricConverter druidToTimelineEventConverter;
    @JsonProperty
    private final List<String> alertEmitters;
    @JsonProperty
    private final long emitWaitTime;
    @JsonProperty
    private final long waitForEventTime;

    @JsonCreator
    public AmbariMetricsEmitterConfig(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="port") Integer port, @JsonProperty(value="protocol") String protocol, @JsonProperty(value="trustStorePath") String trustStorePath, @JsonProperty(value="trustStoreType") String trustStoreType, @JsonProperty(value="trustStorePassword") String trustStorePassword, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="flushPeriod") Long flushPeriod, @JsonProperty(value="maxQueueSize") Integer maxQueueSize, @JsonProperty(value="eventConverter") DruidToTimelineMetricConverter druidToTimelineEventConverter, @JsonProperty(value="alertEmitters") List<String> alertEmitters, @JsonProperty(value="emitWaitTime") Long emitWaitTime, @JsonProperty(value="waitForEventTime") Long waitForEventTime) {
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname can not be null");
        this.port = (Integer)Preconditions.checkNotNull((Object)port, (Object)"port can not be null");
        this.protocol = protocol == null ? DEFAULT_PROTOCOL : protocol;
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.batchSize = batchSize == null ? 100 : batchSize;
        this.flushPeriod = flushPeriod == null ? DEFAULT_FLUSH_PERIOD_MILLIS : flushPeriod;
        this.maxQueueSize = maxQueueSize == null ? Integer.MAX_VALUE : maxQueueSize;
        this.druidToTimelineEventConverter = (DruidToTimelineMetricConverter)Preconditions.checkNotNull((Object)druidToTimelineEventConverter, (Object)"Event converter can not be null");
        this.alertEmitters = alertEmitters == null ? Collections.emptyList() : alertEmitters;
        this.emitWaitTime = emitWaitTime == null ? 0L : emitWaitTime;
        this.waitForEventTime = waitForEventTime == null ? DEFAULT_GET_TIMEOUT_MILLIS : waitForEventTime;
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @JsonProperty
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @JsonProperty
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @JsonProperty
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @JsonProperty
    public long getFlushPeriod() {
        return this.flushPeriod;
    }

    @JsonProperty
    public DruidToTimelineMetricConverter getDruidToTimelineEventConverter() {
        return this.druidToTimelineEventConverter;
    }

    @JsonProperty
    public List<String> getAlertEmitters() {
        return this.alertEmitters;
    }

    @JsonProperty
    public long getEmitWaitTime() {
        return this.emitWaitTime;
    }

    @JsonProperty
    public long getWaitForEventTime() {
        return this.waitForEventTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmbariMetricsEmitterConfig that = (AmbariMetricsEmitterConfig)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.flushPeriod != that.flushPeriod) {
            return false;
        }
        if (this.maxQueueSize != that.maxQueueSize) {
            return false;
        }
        if (this.emitWaitTime != that.emitWaitTime) {
            return false;
        }
        if (this.waitForEventTime != that.waitForEventTime) {
            return false;
        }
        if (!this.hostname.equals(that.hostname)) {
            return false;
        }
        if (!this.protocol.equals(that.protocol)) {
            return false;
        }
        if (this.trustStorePath != null ? !this.trustStorePath.equals(that.trustStorePath) : that.trustStorePath != null) {
            return false;
        }
        if (this.trustStoreType != null ? !this.trustStoreType.equals(that.trustStoreType) : that.trustStoreType != null) {
            return false;
        }
        if (this.trustStorePassword != null ? !this.trustStorePassword.equals(that.trustStorePassword) : that.trustStorePassword != null) {
            return false;
        }
        if (!this.druidToTimelineEventConverter.equals(that.druidToTimelineEventConverter)) {
            return false;
        }
        return this.alertEmitters.equals(that.alertEmitters);
    }

    public int hashCode() {
        int result = this.hostname.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.protocol.hashCode();
        result = 31 * result + (this.trustStorePath != null ? this.trustStorePath.hashCode() : 0);
        result = 31 * result + (this.trustStoreType != null ? this.trustStoreType.hashCode() : 0);
        result = 31 * result + (this.trustStorePassword != null ? this.trustStorePassword.hashCode() : 0);
        result = 31 * result + this.batchSize;
        result = 31 * result + (int)(this.flushPeriod ^ this.flushPeriod >>> 32);
        result = 31 * result + this.maxQueueSize;
        result = 31 * result + this.druidToTimelineEventConverter.hashCode();
        result = 31 * result + this.alertEmitters.hashCode();
        result = 31 * result + (int)(this.emitWaitTime ^ this.emitWaitTime >>> 32);
        result = 31 * result + (int)(this.waitForEventTime ^ this.waitForEventTime >>> 32);
        return result;
    }
}

