/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.ambari.metrics;

import com.fasterxml.jackson.databind.Module;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.emitter.ambari.metrics.AmbariMetricsEmitter;
import org.apache.druid.emitter.ambari.metrics.AmbariMetricsEmitterConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.emitter.core.Emitter;

public class AmbariMetricsEmitterModule
implements DruidModule {
    private static final String EMITTER_TYPE = "ambari-metrics";

    public List<? extends Module> getJacksonModules() {
        return Collections.emptyList();
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.ambari-metrics", AmbariMetricsEmitterConfig.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="ambari-metrics")
    public Emitter getEmitter(AmbariMetricsEmitterConfig emitterConfig, Injector injector) {
        List<Emitter> emitters = emitterConfig.getAlertEmitters().stream().map(name -> (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)name)))).collect(Collectors.toList());
        return new AmbariMetricsEmitter(emitterConfig, emitters);
    }
}

