/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.ambari.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import org.apache.druid.emitter.ambari.metrics.AmbariMetricsEmitter;
import org.apache.druid.emitter.ambari.metrics.DruidToTimelineMetricConverter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

@JsonTypeName(value="all")
public class SendAllTimelineEventConverter
implements DruidToTimelineMetricConverter {
    public static final String DEFAULT_APP_NAME = "druid";
    @JsonProperty
    private final String namespacePrefix;
    @JsonProperty
    private final String appName;

    @JsonProperty
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @JsonCreator
    public SendAllTimelineEventConverter(@JsonProperty(value="namespacePrefix") String namespacePrefix, @JsonProperty(value="appName") String appName) {
        this.namespacePrefix = namespacePrefix;
        this.appName = appName == null ? DEFAULT_APP_NAME : appName;
    }

    @Override
    public TimelineMetric druidEventToTimelineMetric(ServiceMetricEvent serviceMetricEvent) {
        ImmutableList.Builder metricNameBuilder = new ImmutableList.Builder();
        if (!Strings.isNullOrEmpty((String)this.namespacePrefix)) {
            metricNameBuilder.add((Object)this.namespacePrefix);
        }
        metricNameBuilder.add((Object)AmbariMetricsEmitter.sanitize(serviceMetricEvent.getService()));
        ImmutableSortedSet dimNames = ImmutableSortedSet.copyOf(serviceMetricEvent.getUserDims().keySet());
        for (String dimName : dimNames) {
            metricNameBuilder.add((Object)AmbariMetricsEmitter.sanitize(String.valueOf(serviceMetricEvent.getUserDims().get(dimName))));
        }
        metricNameBuilder.add((Object)AmbariMetricsEmitter.sanitize(serviceMetricEvent.getMetric()));
        TimelineMetric metric = new TimelineMetric();
        metric.setMetricName(Joiner.on((String)".").join((Iterable)metricNameBuilder.build()));
        metric.setAppId(this.appName);
        metric.setHostName(serviceMetricEvent.getHost());
        metric.setType(serviceMetricEvent.getFeed());
        metric.setInstanceId(serviceMetricEvent.getService());
        long ts = serviceMetricEvent.getCreatedTime().getMillis();
        metric.setStartTime(ts);
        metric.setTimestamp(ts);
        metric.getMetricValues().put(ts, serviceMetricEvent.getValue().doubleValue());
        return metric;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendAllTimelineEventConverter that = (SendAllTimelineEventConverter)o;
        if (this.namespacePrefix != null ? !this.namespacePrefix.equals(that.namespacePrefix) : that.namespacePrefix != null) {
            return false;
        }
        return this.appName.equals(that.appName);
    }

    public int hashCode() {
        int result = this.namespacePrefix != null ? this.namespacePrefix.hashCode() : 0;
        result = 31 * result + this.appName.hashCode();
        return result;
    }
}

