/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.ambari.metrics;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import org.apache.druid.emitter.ambari.metrics.AmbariMetricsEmitter;
import org.apache.druid.emitter.ambari.metrics.DruidToTimelineMetricConverter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

@JsonTypeName(value="whiteList")
public class WhiteListBasedDruidToTimelineEventConverter
implements DruidToTimelineMetricConverter {
    private static final Logger LOGGER = new Logger(WhiteListBasedDruidToTimelineEventConverter.class);
    private final ImmutableSortedMap<String, ImmutableList<String>> whiteListDimsMapper;
    @JsonProperty
    private final String namespacePrefix;
    @JsonProperty
    private final String appName;
    @JsonProperty
    private final String mapPath;
    private final ObjectMapper mapper;

    @JsonCreator
    public WhiteListBasedDruidToTimelineEventConverter(@JsonProperty(value="namespacePrefix") String namespacePrefix, @JsonProperty(value="appName") String appName, @JsonProperty(value="mapPath") String mapPath, @JacksonInject ObjectMapper mapper) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
        this.mapPath = mapPath;
        this.whiteListDimsMapper = this.readMap(this.mapPath);
        this.namespacePrefix = namespacePrefix;
        this.appName = appName == null ? "druid" : appName;
    }

    @JsonProperty
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    private boolean isInWhiteList(ServiceMetricEvent event) {
        return this.getPrefixKey(event.getMetric(), (SortedMap<String, ?>)this.whiteListDimsMapper) != null;
    }

    private String getPrefixKey(String key, SortedMap<String, ?> whiteList) {
        String prefixKey = null;
        if (whiteList.containsKey(key)) {
            return key;
        }
        SortedMap<String, ?> headMap = whiteList.headMap(key);
        if (!headMap.isEmpty() && key.startsWith(headMap.lastKey())) {
            prefixKey = headMap.lastKey();
        }
        return prefixKey;
    }

    private List<String> getOrderedDimValues(ServiceMetricEvent event) {
        String prefixKey = this.getPrefixKey(event.getMetric(), (SortedMap<String, ?>)this.whiteListDimsMapper);
        if (prefixKey == null) {
            return null;
        }
        ImmutableList.Builder outputList = new ImmutableList.Builder();
        List dimensions = (List)this.whiteListDimsMapper.get((Object)prefixKey);
        if (dimensions == null) {
            return Collections.emptyList();
        }
        for (String dimKey : dimensions) {
            Collection values;
            Object rawValue = event.getUserDims().get(dimKey);
            String value = null;
            if (rawValue instanceof String) {
                value = (String)rawValue;
            } else if (rawValue instanceof Collection && !(values = (Collection)rawValue).isEmpty()) {
                value = (String)values.iterator().next();
            }
            if (value == null) continue;
            outputList.add((Object)AmbariMetricsEmitter.sanitize(value));
        }
        return outputList.build();
    }

    @Override
    public TimelineMetric druidEventToTimelineMetric(ServiceMetricEvent serviceMetricEvent) {
        if (!this.isInWhiteList(serviceMetricEvent)) {
            return null;
        }
        ImmutableList.Builder metricNameBuilder = new ImmutableList.Builder();
        if (!Strings.isNullOrEmpty((String)this.namespacePrefix)) {
            metricNameBuilder.add((Object)this.namespacePrefix);
        }
        metricNameBuilder.add((Object)AmbariMetricsEmitter.sanitize(serviceMetricEvent.getService()));
        metricNameBuilder.addAll(this.getOrderedDimValues(serviceMetricEvent));
        metricNameBuilder.add((Object)AmbariMetricsEmitter.sanitize(serviceMetricEvent.getMetric()));
        TimelineMetric metric = new TimelineMetric();
        metric.setMetricName(Joiner.on((String)".").join((Iterable)metricNameBuilder.build()));
        metric.setAppId(this.appName);
        metric.setHostName(serviceMetricEvent.getHost());
        metric.setType(serviceMetricEvent.getFeed());
        metric.setInstanceId(serviceMetricEvent.getService());
        long ts = serviceMetricEvent.getCreatedTime().getMillis();
        metric.setStartTime(ts);
        metric.setTimestamp(ts);
        metric.getMetricValues().put(ts, serviceMetricEvent.getValue().doubleValue());
        return metric;
    }

    private ImmutableSortedMap<String, ImmutableList<String>> readMap(String mapPath) {
        String actualPath = mapPath;
        try {
            String fileContent;
            if (Strings.isNullOrEmpty((String)mapPath)) {
                URL defaultWhiteListMapUrl = this.getClass().getClassLoader().getResource("defaultWhiteListMap.json");
                actualPath = defaultWhiteListMapUrl.getFile();
                LOGGER.info("using default whiteList map located at [%s]", new Object[]{actualPath});
                fileContent = Resources.toString((URL)defaultWhiteListMapUrl, (Charset)StandardCharsets.UTF_8);
            } else {
                fileContent = Files.asCharSource((File)new File(mapPath), (Charset)StandardCharsets.UTF_8).read();
            }
            return (ImmutableSortedMap)this.mapper.readerFor((TypeReference)new TypeReference<ImmutableSortedMap<String, ImmutableList<String>>>(){}).readValue(fileContent);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Got an exception while parsing file [%s]", new Object[]{actualPath});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhiteListBasedDruidToTimelineEventConverter that = (WhiteListBasedDruidToTimelineEventConverter)o;
        if (this.namespacePrefix != null ? !this.namespacePrefix.equals(that.namespacePrefix) : that.namespacePrefix != null) {
            return false;
        }
        if (!this.appName.equals(that.appName)) {
            return false;
        }
        return this.mapPath != null ? this.mapPath.equals(that.mapPath) : that.mapPath == null;
    }

    public int hashCode() {
        int result = this.namespacePrefix != null ? this.namespacePrefix.hashCode() : 0;
        result = 31 * result + this.appName.hashCode();
        result = 31 * result + (this.mapPath != null ? this.mapPath.hashCode() : 0);
        return result;
    }
}

