/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;

public class ArrayCompressedBigDecimal
extends CompressedBigDecimal {
    public static final CompressedBigDecimal ZERO_COMPRESSED_BIG_DECIMAL = new ArrayCompressedBigDecimal(BigDecimal.ZERO);
    private static final int BYTE_MASK = 255;
    private final int[] array;

    public ArrayCompressedBigDecimal(long initialVal, int scale) {
        super(scale);
        this.array = new int[2];
        this.array[0] = (int)initialVal;
        this.array[1] = (int)(initialVal >>> 32);
    }

    public ArrayCompressedBigDecimal(BigDecimal initialVal) {
        super(initialVal.scale());
        BigInteger unscaled = initialVal.unscaledValue();
        byte[] bytes = unscaled.toByteArray();
        int arrayLen = (bytes.length + 3) / 4;
        this.array = new int[arrayLen];
        if (initialVal.signum() == 0) {
            return;
        }
        int bytesIdx = bytes.length;
        for (int ii = 0; ii < arrayLen; ++ii) {
            this.array[ii] = 0xFF & bytes[--bytesIdx] | (bytesIdx != 0 ? 0xFF & bytes[--bytesIdx] : bytes[0] >> 8) << 8 | (bytesIdx != 0 ? 0xFF & bytes[--bytesIdx] : bytes[0] >> 8) << 16 | (bytesIdx != 0 ? 0xFF & bytes[--bytesIdx] : bytes[0] >> 8) << 24;
        }
    }

    public ArrayCompressedBigDecimal(CompressedBigDecimal initVal) {
        super(initVal.getScale());
        this.array = new int[initVal.getArraySize()];
        for (int ii = 0; ii < initVal.getArraySize(); ++ii) {
            this.array[ii] = initVal.getArrayEntry(ii);
        }
    }

    private ArrayCompressedBigDecimal(int[] array, int scale) {
        super(scale);
        this.array = array;
    }

    public static ArrayCompressedBigDecimal wrap(int[] array, int scale) {
        return new ArrayCompressedBigDecimal(array, scale);
    }

    public static ArrayCompressedBigDecimal allocateZero(int size, int scale) {
        int[] arr = new int[size];
        return new ArrayCompressedBigDecimal(arr, scale);
    }

    public static ArrayCompressedBigDecimal allocateMin(int size, int scale) {
        int[] arr = new int[size];
        ArrayCompressedBigDecimal result = new ArrayCompressedBigDecimal(arr, scale);
        result.setMinValue();
        return result;
    }

    public static ArrayCompressedBigDecimal allocateMax(int size, int scale) {
        int[] arr = new int[size];
        ArrayCompressedBigDecimal result = new ArrayCompressedBigDecimal(arr, scale);
        result.setMaxValue();
        return result;
    }

    @Override
    public CompressedBigDecimal toHeap() {
        return this;
    }

    @Override
    public int getArraySize() {
        return this.array.length;
    }

    int[] getArray() {
        return this.array;
    }

    @Override
    protected int getArrayEntry(int idx) {
        return this.array[idx];
    }

    @Override
    protected void setArrayEntry(int idx, int val) {
        this.array[idx] = val;
    }

    @Override
    protected void setValue(CompressedBigDecimal rhs) {
        Preconditions.checkArgument((rhs.getArraySize() <= this.array.length ? 1 : 0) != 0, (String)"lhs too small to store entry: lhs [%s] vs rhs [%s]", (int)this.getArraySize(), (int)rhs.getArraySize());
        long extension = rhs.getArrayEntry(rhs.getArraySize() - 1) < 0 ? 0xFFFFFFFFL : 0L;
        for (int i = 0; i < this.array.length; ++i) {
            long rhsElement = i < rhs.getArraySize() ? 0xFFFFFFFFL & (long)rhs.getArrayEntry(i) : extension;
            this.array[i] = (int)rhsElement;
        }
    }
}

