/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import java.util.List;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalJsonSerializer;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMaxAggregatorFactory;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMaxSqlAggregator;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMetricSerde;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMinAggregatorFactory;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMinSqlAggregator;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalSumAggregatorFactory;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalSumSqlAggregator;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.sql.guice.SqlBindings;

public class CompressedBigDecimalModule
implements DruidModule {
    public static final String COMPRESSED_BIG_DECIMAL = "compressedBigDecimal";
    public static final String COMPRESSED_BIG_DECIMAL_SUM = "compressedBigDecimalSum";
    public static final String COMPRESSED_BIG_DECIMAL_MAX = "compressedBigDecimalMax";
    public static final String COMPRESSED_BIG_DECIMAL_MIN = "compressedBigDecimalMin";

    public void configure(Binder binder) {
        CompressedBigDecimalModule.registerSerde();
        SqlBindings.addAggregator((Binder)binder, CompressedBigDecimalSumSqlAggregator.class);
        SqlBindings.addAggregator((Binder)binder, CompressedBigDecimalMaxSqlAggregator.class);
        SqlBindings.addAggregator((Binder)binder, CompressedBigDecimalMinSqlAggregator.class);
    }

    public static void registerSerde() {
        if (ComplexMetrics.getSerdeForType((String)COMPRESSED_BIG_DECIMAL) == null) {
            ComplexMetrics.registerSerde((String)COMPRESSED_BIG_DECIMAL, (ComplexMetricSerde)new CompressedBigDecimalMetricSerde());
        }
    }

    public List<Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("CompressedBigDecimalModule").registerSubtypes(new NamedType[]{new NamedType(CompressedBigDecimalSumAggregatorFactory.class, COMPRESSED_BIG_DECIMAL_SUM)}).registerSubtypes(new NamedType[]{new NamedType(CompressedBigDecimalMaxAggregatorFactory.class, COMPRESSED_BIG_DECIMAL_MAX)}).registerSubtypes(new NamedType[]{new NamedType(CompressedBigDecimalMinAggregatorFactory.class, COMPRESSED_BIG_DECIMAL_MIN)}).addSerializer(CompressedBigDecimal.class, (JsonSerializer)new CompressedBigDecimalJsonSerializer()));
    }
}

