/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.segment.data.ObjectStrategy;

public class CompressedBigDecimalObjectStrategy
implements ObjectStrategy<CompressedBigDecimal> {
    public int compare(CompressedBigDecimal o1, CompressedBigDecimal o2) {
        return o1.compareTo(o2);
    }

    public Class getClazz() {
        return CompressedBigDecimal.class;
    }

    public CompressedBigDecimal fromByteBuffer(ByteBuffer buffer, int numBytes) {
        ByteBuffer myBuf = buffer.slice();
        myBuf.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuf = myBuf.asIntBuffer();
        int scale = intBuf.get();
        int[] array = new int[numBytes / 4 - 1];
        intBuf.get(array);
        return ArrayCompressedBigDecimal.wrap(array, scale);
    }

    public byte[] toBytes(CompressedBigDecimal val) {
        ByteBuffer buf = ByteBuffer.allocate(4 * (val.getArraySize() + 1));
        buf.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuf = buf.asIntBuffer();
        intBuf.put(val.getScale());
        for (int ii = 0; ii < val.getArraySize(); ++ii) {
            intBuf.put(val.getArrayEntry(ii));
        }
        return buf.array();
    }
}

