/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.CastedLiteralOperandTypeCheckers;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalAggregatorFactoryCreator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class CompressedBigDecimalSqlAggregatorBase
implements SqlAggregator {
    private final SqlAggFunction sqlAggFunction;
    private final CompressedBigDecimalAggregatorFactoryCreator factoryCreator;

    protected CompressedBigDecimalSqlAggregatorBase(String name, CompressedBigDecimalAggregatorFactoryCreator factoryCreator) {
        this.sqlAggFunction = new CompressedBigDecimalSqlAggFunction(name);
        this.factoryCreator = factoryCreator;
    }

    public SqlAggFunction calciteFunction() {
        return this.sqlAggFunction;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        if (aggregateCall.getArgList().size() < 1) {
            return null;
        }
        DruidExpression sumColumn = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)inputAccessor.getField(((Integer)aggregateCall.getArgList().get(0)).intValue()));
        if (sumColumn == null) {
            return null;
        }
        String sumColumnName = sumColumn.isDirectColumnAccess() ? sumColumn.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(sumColumn, ColumnType.UNKNOWN_COMPLEX);
        Integer size = null;
        if (aggregateCall.getArgList().size() >= 2) {
            RexNode sizeArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(1)).intValue());
            size = ((Number)((Object)RexLiteral.value((RexNode)sizeArg))).intValue();
        }
        Integer scale = null;
        if (aggregateCall.getArgList().size() >= 3) {
            RexNode scaleArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(2)).intValue());
            scale = ((Number)((Object)RexLiteral.value((RexNode)scaleArg))).intValue();
        }
        Boolean useStrictNumberParsing = null;
        if (aggregateCall.getArgList().size() >= 4) {
            RexNode useStrictNumberParsingArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(3)).intValue());
            useStrictNumberParsing = RexLiteral.booleanValue((RexNode)useStrictNumberParsingArg);
        }
        AggregatorFactory aggregatorFactory = this.factoryCreator.create(StringUtils.format((String)"%s:agg", (Object[])new Object[]{name}), sumColumnName, size, scale, useStrictNumberParsing);
        return Aggregation.create((List)ImmutableList.of((Object)aggregatorFactory), null);
    }

    private static class CompressedBigDecimalSqlAggFunction
    extends SqlAggFunction {
        private CompressedBigDecimalSqlAggFunction(String name) {
            super(name, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARCHAR), null, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)("'" + name + "(column, size)'"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.EXACT_NUMERIC})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)("'" + name + "(column, size, scale)'"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.EXACT_NUMERIC})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)("'" + name + "(column, size, scale, strictNumberParsing)'"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL, OperandTypes.BOOLEAN}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.BOOLEAN})})}), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.IGNORED);
        }
    }
}

