/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalAggregatorFactoryBase;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalSumAggregateCombiner;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalSumAggregator;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalSumBufferAggregator;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;

public class CompressedBigDecimalSumAggregatorFactory
extends CompressedBigDecimalAggregatorFactoryBase {
    private static final byte CACHE_TYPE_ID = 57;

    @JsonCreator
    public CompressedBigDecimalSumAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="size", required=false) Integer size, @JsonProperty(value="scale", required=false) Integer scale, @JsonProperty(value="strictNumberParsing", required=false) Boolean strictNumberParsing) {
        super(name, fieldName, size, scale, strictNumberParsing, (byte)57);
    }

    @Override
    protected Aggregator factorize(ColumnSelectorFactory metricFactory, @Nonnull ColumnValueSelector<CompressedBigDecimal> selector) {
        return new CompressedBigDecimalSumAggregator(this.size, this.scale, selector, this.strictNumberParsing);
    }

    @Override
    protected BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, @Nonnull ColumnValueSelector<CompressedBigDecimal> selector) {
        return new CompressedBigDecimalSumBufferAggregator(this.size, this.scale, selector, this.strictNumberParsing);
    }

    @Override
    @Nullable
    public Object combine(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return ArrayCompressedBigDecimal.allocateZero(this.size, this.scale);
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        ArrayCompressedBigDecimal retVal = ArrayCompressedBigDecimal.allocateZero(this.size, this.scale);
        CompressedBigDecimal left = (CompressedBigDecimal)lhs;
        CompressedBigDecimal right = (CompressedBigDecimal)rhs;
        if (!left.isZero()) {
            retVal.accumulateSum(left);
        }
        if (!right.isZero()) {
            retVal.accumulateSum(right);
        }
        return retVal;
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new CompressedBigDecimalSumAggregatorFactory(this.name, this.name, this.size, this.scale, this.strictNumberParsing);
    }

    @Override
    public AggregateCombiner<CompressedBigDecimal> makeAggregateCombiner() {
        return new CompressedBigDecimalSumAggregateCombiner();
    }

    @Override
    public String toString() {
        return "CompressedBigDecimalSumAggregatorFactory{name='" + this.getName() + '\'' + ", type='" + this.getIntermediateType().asTypeString() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", requiredFields='" + this.requiredFields() + '\'' + ", size='" + this.getSize() + '\'' + ", scale='" + this.getScale() + '\'' + ", strictNumberParsing='" + this.getStrictNumberParsing() + '\'' + '}';
    }
}

