/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedBigDecimalLongColumnSerializer
implements GenericColumnSerializer<CompressedBigDecimal> {
    private static final byte VERSION = 1;
    private final CompressedVSizeColumnarIntsSerializer scaleWriter;
    private final V3CompressedVSizeColumnarMultiIntsSerializer magnitudeWriter;

    public static CompressedBigDecimalLongColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase) {
        return new CompressedBigDecimalLongColumnSerializer(CompressedVSizeColumnarIntsSerializer.create((String)"dummy", (SegmentWriteOutMedium)segmentWriteOutMedium, (String)String.format(Locale.ROOT, "%s.scale", filenameBase), (int)16, (CompressionStrategy)CompressionStrategy.LZ4, (Closer)segmentWriteOutMedium.getCloser()), V3CompressedVSizeColumnarMultiIntsSerializer.create((String)"dummy", (SegmentWriteOutMedium)segmentWriteOutMedium, (String)String.format(Locale.ROOT, "%s.magnitude", filenameBase), (int)Integer.MAX_VALUE, (CompressionStrategy)CompressionStrategy.LZ4));
    }

    public CompressedBigDecimalLongColumnSerializer(CompressedVSizeColumnarIntsSerializer scaleWriter, V3CompressedVSizeColumnarMultiIntsSerializer magnitudeWriter) {
        this.scaleWriter = scaleWriter;
        this.magnitudeWriter = magnitudeWriter;
    }

    public void open() throws IOException {
        this.scaleWriter.open();
        this.magnitudeWriter.open();
    }

    public void serialize(ColumnValueSelector<? extends CompressedBigDecimal> obj) throws IOException {
        CompressedBigDecimal abd = (CompressedBigDecimal)obj.getObject();
        int[] array = new int[abd.getArraySize()];
        for (int ii = 0; ii < abd.getArraySize(); ++ii) {
            array[ii] = abd.getArrayEntry(ii);
        }
        this.scaleWriter.addValue(abd.getScale());
        this.magnitudeWriter.addValues((IndexedInts)new ArrayBasedIndexedInts(array));
    }

    public long getSerializedSize() throws IOException {
        return 1L + this.scaleWriter.getSerializedSize() + this.magnitudeWriter.getSerializedSize();
    }

    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        this.scaleWriter.writeTo(channel, smoosher);
        this.magnitudeWriter.writeTo(channel, smoosher);
    }
}

