/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalAggregatorFactoryBase;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMaxAggregateCombiner;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMaxAggregator;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalMaxBufferAggregator;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;

public class CompressedBigDecimalMaxAggregatorFactory
extends CompressedBigDecimalAggregatorFactoryBase {
    private static final byte CACHE_TYPE_ID = 55;

    @JsonCreator
    public CompressedBigDecimalMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="size", required=false) Integer size, @JsonProperty(value="scale", required=false) Integer scale, @JsonProperty(value="strictNumberParsing", required=false) Boolean strictNumberParsing) {
        super(name, fieldName, size, scale, strictNumberParsing, (byte)55);
    }

    @Override
    protected Aggregator factorize(ColumnSelectorFactory metricFactory, ColumnValueSelector<CompressedBigDecimal> selector) {
        return new CompressedBigDecimalMaxAggregator(this.size, this.scale, selector, this.strictNumberParsing);
    }

    @Override
    protected BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, ColumnValueSelector<CompressedBigDecimal> selector) {
        return new CompressedBigDecimalMaxBufferAggregator(this.size, this.scale, selector, this.strictNumberParsing);
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return null;
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        ArrayCompressedBigDecimal retVal = ArrayCompressedBigDecimal.allocateMin(this.size, this.scale);
        CompressedBigDecimal left = (CompressedBigDecimal)lhs;
        CompressedBigDecimal right = (CompressedBigDecimal)rhs;
        retVal.accumulateMax(left);
        retVal.accumulateMax(right);
        return retVal;
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new CompressedBigDecimalMaxAggregatorFactory(this.name, this.name, this.size, this.scale, this.strictNumberParsing);
    }

    @Override
    public AggregateCombiner<CompressedBigDecimal> makeAggregateCombiner() {
        return new CompressedBigDecimalMaxAggregateCombiner();
    }

    @Override
    public String toString() {
        return "CompressedBigDecimalMaxAggregatorFactory{name='" + this.getName() + '\'' + ", type='" + this.getIntermediateType().asTypeString() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", requiredFields='" + this.requiredFields() + '\'' + ", size='" + this.getSize() + '\'' + ", scale='" + this.getScale() + '\'' + ", strictNumberParsing='" + this.getStrictNumberParsing() + '\'' + '}';
    }
}

