/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalColumnPartSupplier;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalLongColumnSerializer;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimalObjectStrategy;
import org.apache.druid.compressedbigdecimal.Utils;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedBigDecimalMetricSerde
extends ComplexMetricSerde {
    private final CompressedBigDecimalObjectStrategy strategy = new CompressedBigDecimalObjectStrategy();

    public String getTypeName() {
        return "compressedBigDecimal";
    }

    public ComplexMetricExtractor<CompressedBigDecimal> getExtractor() {
        return new ComplexMetricExtractor<CompressedBigDecimal>(){

            public Class<CompressedBigDecimal> extractedClass() {
                return CompressedBigDecimal.class;
            }

            public CompressedBigDecimal extractValue(InputRow inputRow, String metricName) {
                Object rawMetric = inputRow.getRaw(metricName);
                return Utils.objToCompressedBigDecimal(rawMetric);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        builder.setComplexColumnSupplier((Supplier)CompressedBigDecimalColumnPartSupplier.fromByteBuffer(buffer));
    }

    public CompressedBigDecimalLongColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column, IndexSpec indexSpec) {
        return CompressedBigDecimalLongColumnSerializer.create(segmentWriteOutMedium, column);
    }

    public ObjectStrategy<CompressedBigDecimal> getObjectStrategy() {
        return this.strategy;
    }
}

