/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;

public class ByteBufferCompressedBigDecimal
extends CompressedBigDecimal {
    private final ByteBuffer buf;
    private final int position;
    private final int size;

    public ByteBufferCompressedBigDecimal(ByteBuffer buf, int position, int size, int scale) {
        super(scale);
        this.buf = buf;
        this.position = position;
        this.size = size;
    }

    public ByteBufferCompressedBigDecimal(ByteBuffer buf, int position, CompressedBigDecimal val) {
        super(val.getScale());
        this.buf = buf;
        this.position = position;
        this.size = val.getArraySize();
        ByteBufferCompressedBigDecimal.copyToBuffer(buf, position, this.size, val);
    }

    public static void initZero(ByteBuffer buf, int position, int size) {
        for (int i = 0; i < size; ++i) {
            buf.putInt(position + i * 4, 0);
        }
    }

    public static void initMin(ByteBuffer buf, int position, int size) {
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                buf.putInt(position + i * 4, Integer.MIN_VALUE);
                continue;
            }
            buf.putInt(position + i * 4, 0);
        }
    }

    public static void initMax(ByteBuffer buf, int position, int size) {
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                buf.putInt(position + i * 4, Integer.MAX_VALUE);
                continue;
            }
            buf.putInt(position + i * 4, -1);
        }
    }

    @Override
    public CompressedBigDecimal toHeap() {
        return new ArrayCompressedBigDecimal(this);
    }

    @Override
    public int getArraySize() {
        return this.size;
    }

    @Override
    protected int getArrayEntry(int idx) {
        return this.buf.getInt(this.position + idx * 4);
    }

    @Override
    protected void setArrayEntry(int idx, int val) {
        this.buf.putInt(this.position + idx * 4, val);
    }

    @Override
    protected void setValue(CompressedBigDecimal rhs) {
        Preconditions.checkArgument((rhs.getArraySize() <= this.getArraySize() ? 1 : 0) != 0, (String)"lhs too small to store entry: lhs [%s] vs rhs [%s]", (int)this.size, (int)rhs.getArraySize());
        long extension = rhs.getArrayEntry(rhs.getArraySize() - 1) < 0 ? 0xFFFFFFFFL : 0L;
        for (int i = 0; i < this.size; ++i) {
            long rhsElement = i < rhs.getArraySize() ? 0xFFFFFFFFL & (long)rhs.getArrayEntry(i) : extension;
            this.buf.putInt(this.position + i * 4, (int)rhsElement);
        }
    }

    public static void copyToBuffer(ByteBuffer buf, int position, int size, CompressedBigDecimal val) {
        if (val.getArraySize() > size) {
            throw new IllegalArgumentException("Right hand side too big to fit in the result value");
        }
        for (int ii = 0; ii < size; ++ii) {
            buf.putInt(position + ii * 4, val.getArrayEntry(ii));
        }
    }
}

