/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;

public class CompressedBigDecimalColumn
implements ComplexColumn {
    public static final Logger LOGGER = new Logger(CompressedBigDecimalColumn.class);
    private final int length;
    private final ColumnarInts scale;
    private final ColumnarMultiInts magnitude;

    public CompressedBigDecimalColumn(int length, ColumnarInts scale, ColumnarMultiInts magnitude) {
        this.length = length;
        this.scale = scale;
        this.magnitude = magnitude;
    }

    public Class<CompressedBigDecimalColumn> getClazz() {
        return CompressedBigDecimalColumn.class;
    }

    public String getTypeName() {
        return "compressedBigDecimal";
    }

    @Nullable
    public CompressedBigDecimal getRowValue(int rowNum) {
        int s = this.scale.get(rowNum);
        IndexedInts vals = this.magnitude.get(rowNum);
        int size = vals.size();
        int[] array = new int[size];
        for (int ii = 0; ii < size; ++ii) {
            array[ii] = vals.get(ii);
        }
        return ArrayCompressedBigDecimal.wrap(array, s);
    }

    public int getLength() {
        return this.length;
    }

    public ColumnValueSelector makeColumnValueSelector(final ReadableOffset offset) {
        return new ObjectColumnSelector<CompressedBigDecimal>(){

            @Nullable
            public CompressedBigDecimal getObject() {
                return CompressedBigDecimalColumn.this.getRowValue(offset.getOffset());
            }

            public Class<CompressedBigDecimal> classOfObject() {
                return CompressedBigDecimal.class;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", (Object)CompressedBigDecimalColumn.this);
            }
        };
    }

    public void close() {
        try {
            this.scale.close();
        }
        catch (IOException ex) {
            LOGGER.error((Throwable)ex, "failed to clean up scale part of CompressedBigDecimalColumn", new Object[0]);
        }
        try {
            this.magnitude.close();
        }
        catch (IOException ex) {
            LOGGER.error((Throwable)ex, "failed to clean up magnitude part of CompressedBigDecimalColumn", new Object[0]);
        }
    }
}

