/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.function.ToIntBiFunction;
import javax.annotation.Nullable;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.ObjBiIntConsumer;
import org.apache.druid.java.util.common.ISE;

public class Utils {
    public static CompressedBigDecimal accumulateSum(CompressedBigDecimal lhs, BigDecimal rhs) {
        ArrayCompressedBigDecimal abd = new ArrayCompressedBigDecimal(rhs.setScale(lhs.getScale(), RoundingMode.HALF_UP));
        return lhs.accumulateSum(abd);
    }

    public static CompressedBigDecimal accumulateSum(CompressedBigDecimal lhs, long rhs, int rhsScale) {
        ArrayCompressedBigDecimal abd = new ArrayCompressedBigDecimal(rhs, rhsScale);
        return lhs.accumulateSum(abd);
    }

    public static void accumulateSum(ByteBuffer buf, int pos, int lhsSize, int lhsScale, CompressedBigDecimal rhs) {
        Preconditions.checkArgument((rhs.getScale() == lhsScale ? 1 : 0) != 0, (String)"scales do not match: lhs [%s] vs rhs [%s]", (int)lhsScale, (int)rhs.getScale());
        Preconditions.checkArgument((rhs.getArraySize() <= lhsSize ? 1 : 0) != 0, (Object)"Right hand side too big to fit in the result value");
        BufferAccessor accessor = BufferAccessor.prepare(pos);
        CompressedBigDecimal.internalAdd(lhsSize, buf, accessor, accessor, rhs.getArraySize(), rhs, CompressedBigDecimal::getArrayEntry);
    }

    public static CompressedBigDecimal scaleIfNeeded(CompressedBigDecimal val, int scale) {
        if (val.getScale() != scale) {
            return new ArrayCompressedBigDecimal(val.toBigDecimal().setScale(scale, RoundingMode.UP));
        }
        return val;
    }

    public static CompressedBigDecimal scale(CompressedBigDecimal val, int scale) {
        return new ArrayCompressedBigDecimal(val.toBigDecimal().setScale(scale, RoundingMode.UP));
    }

    public static CompressedBigDecimal objToCompressedBigDecimal(Object obj) {
        return Utils.objToCompressedBigDecimal(obj, false);
    }

    @Nullable
    public static CompressedBigDecimal objToCompressedBigDecimalWithScale(Object obj, int scale, boolean strictNumberParse) {
        CompressedBigDecimal compressedBigDecimal = Utils.objToCompressedBigDecimal(obj, strictNumberParse);
        if (compressedBigDecimal != null) {
            return Utils.scaleIfNeeded(compressedBigDecimal, scale);
        }
        return null;
    }

    public static CompressedBigDecimal objToCompressedBigDecimal(Object obj, boolean strictNumberParse) {
        CompressedBigDecimal result;
        if (obj == null) {
            result = null;
        } else if (obj instanceof String) {
            try {
                result = new ArrayCompressedBigDecimal(new BigDecimal((String)obj));
            }
            catch (NumberFormatException e) {
                if (strictNumberParse) {
                    throw e;
                }
                result = new ArrayCompressedBigDecimal(0L, 0);
            }
        } else if (obj instanceof BigDecimal) {
            result = new ArrayCompressedBigDecimal((BigDecimal)obj);
        } else if (obj instanceof Long) {
            result = new ArrayCompressedBigDecimal(new BigDecimal((Long)obj));
        } else if (obj instanceof Integer) {
            result = new ArrayCompressedBigDecimal(new BigDecimal((Integer)obj));
        } else if (obj instanceof Double) {
            result = new ArrayCompressedBigDecimal(BigDecimal.valueOf((Double)obj));
        } else if (obj instanceof Float) {
            result = new ArrayCompressedBigDecimal(BigDecimal.valueOf(((Float)obj).floatValue()));
        } else if (obj instanceof CompressedBigDecimal) {
            result = (CompressedBigDecimal)obj;
        } else {
            throw new ISE("Unknown value type: [%s]", new Object[]{obj.getClass().getName()});
        }
        return result;
    }

    private static class BufferAccessor
    implements ToIntBiFunction<ByteBuffer, Integer>,
    ObjBiIntConsumer<ByteBuffer> {
        private static final ThreadLocal<BufferAccessor> CACHE = ThreadLocal.withInitial(BufferAccessor::new);
        private int position = 0;

        private BufferAccessor() {
        }

        public static BufferAccessor prepare(int position) {
            BufferAccessor accessor = CACHE.get();
            accessor.position = position;
            return accessor;
        }

        @Override
        public void accept(ByteBuffer buf, int idx, int val) {
            buf.putInt(this.position + idx * 4, val);
        }

        @Override
        public int applyAsInt(ByteBuffer buf, Integer idx) {
            return buf.getInt(this.position + idx * 4);
        }
    }
}

