/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.LongAggregateCombiner;
import org.apache.druid.query.aggregation.TimestampAggregator;
import org.apache.druid.query.aggregation.TimestampBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.joda.time.DateTime;

public abstract class TimestampAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType FINALIZED_TYPE = ColumnType.ofComplex((String)"dateTime");
    final String name;
    @Nullable
    final String fieldName;
    @Nullable
    final String timeFormat;
    private final Comparator<Long> comparator;
    private final Long initValue;
    private TimestampSpec timestampSpec;

    TimestampAggregatorFactory(String name, @Nullable String fieldName, @Nullable String timeFormat, Comparator<Long> comparator, Long initValue) {
        this.name = name;
        this.fieldName = fieldName;
        this.timeFormat = timeFormat;
        this.comparator = comparator;
        this.initValue = initValue;
        this.timestampSpec = new TimestampSpec(fieldName, timeFormat, null);
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new TimestampAggregator((BaseObjectColumnValueSelector)metricFactory.makeColumnValueSelector(this.timestampSpec.getTimestampColumn()), this.timestampSpec, this.comparator, this.initValue);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new TimestampBufferAggregator((BaseObjectColumnValueSelector)metricFactory.makeColumnValueSelector(this.timestampSpec.getTimestampColumn()), this.timestampSpec, this.comparator, this.initValue);
    }

    public Comparator getComparator() {
        return TimestampAggregator.COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        return TimestampAggregator.combineValues(this.comparator, lhs, rhs);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new LongAggregateCombiner(){
            private long result;

            public void reset(ColumnValueSelector selector) {
                this.result = this.getTimestamp(selector);
            }

            private long getTimestamp(ColumnValueSelector selector) {
                if (Long.class.equals((Object)selector.classOfObject())) {
                    return selector.getLong();
                }
                Object input = selector.getObject();
                return TimestampAggregatorFactory.convertLong(TimestampAggregatorFactory.this.timestampSpec, input);
            }

            public void fold(ColumnValueSelector selector) {
                long other = this.getTimestamp(selector);
                if (TimestampAggregatorFactory.this.comparator.compare(this.result, other) <= 0) {
                    this.result = other;
                }
            }

            public long getLong() {
                return this.result;
            }
        };
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && ((Object)((Object)this)).getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public Object deserialize(Object object) {
        return object;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : DateTimes.utc((long)((Long)object));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    @JsonProperty
    public String getTimeFormat() {
        return this.timeFormat;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.timestampSpec.getTimestampColumn());
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(25).appendString(this.timestampSpec.getTimestampColumn()).appendString(this.timestampSpec.getTimestampFormat()).build();
    }

    public ColumnType getIntermediateType() {
        return ColumnType.LONG;
    }

    public ColumnType getResultType() {
        return FINALIZED_TYPE;
    }

    public int getMaxIntermediateSize() {
        return 8;
    }

    @Nullable
    static Long convertLong(TimestampSpec timestampSpec, Object input) {
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        if (input instanceof DateTime) {
            return ((DateTime)input).getMillis();
        }
        if (input instanceof Timestamp) {
            return ((Timestamp)input).getTime();
        }
        if (input instanceof String) {
            return timestampSpec.parseDateTime(input).getMillis();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TimestampAggregatorFactory that = (TimestampAggregatorFactory)((Object)o);
        return this.name.equals(that.name) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.timeFormat, that.timeFormat) && this.comparator.equals(that.comparator) && this.initValue.equals(that.initValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.timeFormat, this.comparator, this.initValue);
    }
}

