/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TimestampAggregatorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class TimestampBufferAggregator
implements BufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final TimestampSpec timestampSpec;
    private final Comparator<Long> comparator;
    private final Long initValue;

    public TimestampBufferAggregator(BaseObjectColumnValueSelector selector, TimestampSpec timestampSpec, Comparator<Long> comparator, Long initValue) {
        this.selector = selector;
        this.timestampSpec = timestampSpec;
        this.comparator = comparator;
        this.initValue = initValue;
    }

    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, this.initValue);
    }

    public void aggregate(ByteBuffer buf, int position) {
        Long newTime = TimestampAggregatorFactory.convertLong(this.timestampSpec, this.selector.getObject());
        if (newTime != null) {
            long prev = buf.getLong(position);
            buf.putLong(position, this.comparator.compare(prev, newTime) > 0 ? prev : newTime);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (Object)this.selector);
        inspector.visit("comparator", this.comparator);
    }
}

