/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.MapVirtualColumnDimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.data.ZeroIndexedInts;

final class StringTypeMapVirtualColumnDimensionSelector
extends MapVirtualColumnDimensionSelector {
    private final String subColumnName;
    private final SingleIndexedInt indexedInt = new SingleIndexedInt();

    StringTypeMapVirtualColumnDimensionSelector(DimensionSelector keySelector, DimensionSelector valueSelector, String subColumnName) {
        super(keySelector, valueSelector);
        this.subColumnName = (String)Preconditions.checkNotNull((Object)subColumnName, (Object)"subColumnName");
    }

    public IndexedInts getRow() {
        int valueIndex = this.findValueIndicesIndexForSubColumn();
        if (valueIndex < 0) {
            return ZeroIndexedInts.instance();
        }
        this.indexedInt.setValue(valueIndex);
        return this.indexedInt;
    }

    public ValueMatcher makeValueMatcher(final @Nullable String value) {
        return new ValueMatcher(){

            public boolean matches() {
                return Objects.equals(value, StringTypeMapVirtualColumnDimensionSelector.this.getObject());
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("keySelector", (HotLoopCallee)StringTypeMapVirtualColumnDimensionSelector.this.getKeySelector());
                inspector.visit("valueSelector", (HotLoopCallee)StringTypeMapVirtualColumnDimensionSelector.this.getValueSelector());
                inspector.visit("subColumnName", StringTypeMapVirtualColumnDimensionSelector.this.subColumnName);
            }
        };
    }

    public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
        return new ValueMatcher(){

            public boolean matches() {
                return predicate.apply((Object)((String)StringTypeMapVirtualColumnDimensionSelector.this.getObject()));
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("keySelector", (HotLoopCallee)StringTypeMapVirtualColumnDimensionSelector.this.getKeySelector());
                inspector.visit("valueSelector", (HotLoopCallee)StringTypeMapVirtualColumnDimensionSelector.this.getValueSelector());
                inspector.visit("subColumnName", StringTypeMapVirtualColumnDimensionSelector.this.subColumnName);
            }
        };
    }

    public int getValueCardinality() {
        return -1;
    }

    @Nullable
    public String lookupName(int id) {
        int valueIndex = this.findValueIndicesIndexForSubColumn();
        if (valueIndex == id) {
            return this.getValueSelector().lookupName(id);
        }
        return null;
    }

    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Nullable
    public IdLookup idLookup() {
        DimensionSelector valueSelector = this.getValueSelector();
        IdLookup valueLookup = valueSelector.idLookup();
        if (valueLookup != null) {
            int valueIndex = this.findValueIndicesIndexForSubColumn();
            return name -> {
                int candidate = valueLookup.lookupId(name);
                if (candidate == valueIndex) {
                    return candidate;
                }
                return -1;
            };
        }
        return null;
    }

    @Nullable
    public Object getObject() {
        int valueIndex = this.findValueIndicesIndexForSubColumn();
        if (valueIndex < 0) {
            return null;
        }
        DimensionSelector valueSelector = this.getValueSelector();
        IndexedInts valueIndices = valueSelector.getRow();
        return valueSelector.lookupName(valueIndices.get(valueIndex));
    }

    private int findValueIndicesIndexForSubColumn() {
        DimensionSelector keySelector = this.getKeySelector();
        DimensionSelector valueSelector = this.getValueSelector();
        IndexedInts keyIndices = keySelector.getRow();
        IndexedInts valueIndices = valueSelector.getRow();
        int limit = Math.min(keyIndices.size(), valueIndices.size());
        return IntStream.range(0, limit).filter(i -> this.subColumnName.equals(keySelector.lookupName(keyIndices.get(i)))).findAny().orElse(-1);
    }

    public Class classOfObject() {
        return String.class;
    }
}

