/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.materializedview;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.indexing.overlord.DataSourceMetadata;

public class DerivativeDataSourceMetadata
implements DataSourceMetadata {
    private final String baseDataSource;
    private final Set<String> dimensions;
    private final Set<String> metrics;

    @JsonCreator
    public DerivativeDataSourceMetadata(@JsonProperty(value="baseDataSource") String baseDataSource, @JsonProperty(value="dimensions") Set<String> dimensions, @JsonProperty(value="metrics") Set<String> metrics) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)baseDataSource) ? 1 : 0) != 0, (Object)"baseDataSource cannot be null or empty. Please provide a baseDataSource.");
        this.baseDataSource = baseDataSource;
        this.dimensions = (Set)Preconditions.checkNotNull(dimensions, (Object)"dimensions cannot be null. This is not a valid DerivativeDataSourceMetadata.");
        this.metrics = (Set)Preconditions.checkNotNull(metrics, (Object)"metrics cannot be null. This is not a valid DerivativeDataSourceMetadata.");
    }

    @JsonProperty(value="baseDataSource")
    public String getBaseDataSource() {
        return this.baseDataSource;
    }

    @JsonProperty(value="dimensions")
    public Set<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="metrics")
    public Set<String> getMetrics() {
        return this.metrics;
    }

    public boolean isValidStart() {
        return false;
    }

    public DataSourceMetadata asStartMetadata() {
        return this;
    }

    public boolean matches(DataSourceMetadata other) {
        return this.equals(other);
    }

    public DataSourceMetadata plus(DataSourceMetadata other) {
        throw new UnsupportedOperationException("Derivative dataSource metadata is not allowed to plus");
    }

    public DataSourceMetadata minus(DataSourceMetadata other) {
        throw new UnsupportedOperationException("Derivative dataSource metadata is not allowed to minus");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DerivativeDataSourceMetadata that = (DerivativeDataSourceMetadata)o;
        return this.baseDataSource.equals(that.getBaseDataSource()) && this.dimensions.equals(that.getDimensions()) && this.metrics.equals(that.getMetrics());
    }

    public int hashCode() {
        return Objects.hash(this.baseDataSource, this.dimensions, this.metrics);
    }

    public Set<String> getColumns() {
        HashSet fields = Sets.newHashSet(this.dimensions);
        fields.addAll(this.metrics);
        return fields;
    }

    public String toString() {
        return "DerivedDataSourceMetadata{baseDataSource=" + this.baseDataSource + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + '}';
    }
}

