/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.avro.AvroOCFReader;
import org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;

public class AvroOCFInputFormat
extends NestedInputFormat {
    private static final Logger LOGGER = new Logger(AvroOCFInputFormat.class);
    private final boolean binaryAsString;
    private final boolean extractUnionsByType;
    private final Map<String, Object> schema;
    @Nullable
    private final Schema readerSchema;

    @JsonCreator
    public AvroOCFInputFormat(@JacksonInject @Json ObjectMapper mapper, @JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="schema") @Nullable Map<String, Object> schema, @JsonProperty(value="binaryAsString") @Nullable Boolean binaryAsString, @JsonProperty(value="extractUnionsByType") @Nullable Boolean extractUnionsByType) throws Exception {
        super(flattenSpec);
        this.schema = schema;
        if (schema != null) {
            String schemaStr = mapper.writeValueAsString(schema);
            LOGGER.debug("Initialising with reader schema: [%s]", new Object[]{schemaStr});
            this.readerSchema = new Schema.Parser().parse(schemaStr);
        } else {
            this.readerSchema = null;
        }
        this.binaryAsString = binaryAsString != null && binaryAsString != false;
        this.extractUnionsByType = extractUnionsByType != null && extractUnionsByType != false;
    }

    public boolean isSplittable() {
        return false;
    }

    @JsonProperty
    public Map<String, Object> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Boolean getBinaryAsString() {
        return this.binaryAsString;
    }

    @JsonProperty
    public Boolean isExtractUnionsByType() {
        return this.extractUnionsByType;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new AvroOCFReader(inputRowSchema, source, temporaryDirectory, this.readerSchema, this.getFlattenSpec(), this.binaryAsString, this.extractUnionsByType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvroOCFInputFormat that = (AvroOCFInputFormat)((Object)o);
        return this.binaryAsString == that.binaryAsString && this.extractUnionsByType == that.extractUnionsByType && Objects.equals(this.readerSchema, that.readerSchema);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.binaryAsString, this.readerSchema, this.extractUnionsByType);
    }

    public String toString() {
        return "AvroOCFInputFormat{binaryAsString=" + this.binaryAsString + ", extractUnionsByType=" + this.extractUnionsByType + ", readerSchema=" + this.readerSchema + '}';
    }
}

