/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.data.input.avro.AvroValueRecordReader;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class AvroValueInputFormat
extends FileInputFormat<NullWritable, GenericRecord> {
    private static final Logger log = new Logger(AvroValueInputFormat.class);
    private static final String CONF_INPUT_VALUE_SCHEMA_PATH = "avro.schema.input.value.path";

    public RecordReader<NullWritable, GenericRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        String schemaFilePath;
        Schema readerSchema = AvroJob.getInputValueSchema((Configuration)context.getConfiguration());
        if (readerSchema == null && StringUtils.isNotBlank((String)(schemaFilePath = context.getConfiguration().get(CONF_INPUT_VALUE_SCHEMA_PATH)))) {
            log.info("Using file: %s as reader schema.", new Object[]{schemaFilePath});
            try (FSDataInputStream inputStream = FileSystem.get((Configuration)context.getConfiguration()).open(new Path(schemaFilePath));){
                readerSchema = new Schema.Parser().parse((InputStream)inputStream);
            }
        }
        if (null == readerSchema) {
            log.warn("Reader schema was not set. Use AvroJob.setInputKeySchema() if desired.", new Object[0]);
            log.info("Using a reader schema equal to the writer schema.", new Object[0]);
        }
        return new AvroValueRecordReader(readerSchema);
    }
}

