/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.azure;

import com.google.common.base.Predicate;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.storage.azure.AzureByteSource;
import org.apache.druid.storage.azure.AzureByteSourceFactory;
import org.apache.druid.storage.azure.AzureUtils;

public class AzureEntity
extends RetryingInputEntity {
    private final CloudObjectLocation location;
    private final AzureByteSource byteSource;

    @AssistedInject
    AzureEntity(@Nonnull @Assisted CloudObjectLocation location, @Nonnull AzureByteSourceFactory byteSourceFactory) {
        this.location = location;
        this.byteSource = byteSourceFactory.create(location.getBucket(), location.getPath());
    }

    public URI getUri() {
        return this.location.toUri("azure");
    }

    public Predicate<Throwable> getRetryCondition() {
        return AzureUtils.AZURE_RETRY;
    }

    protected InputStream readFrom(long offset) throws IOException {
        return this.byteSource.openStream(offset);
    }

    protected String getPath() {
        return this.location.getPath();
    }
}

