/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.azure;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.azure.AzureEntity;
import org.apache.druid.data.input.azure.AzureEntityFactory;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.storage.azure.AzureCloudBlobHolderToCloudObjectLocationConverter;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;
import org.apache.druid.utils.Streams;

public class AzureInputSource
extends CloudObjectInputSource {
    public static final String SCHEME = "azure";
    private final AzureStorage storage;
    private final AzureEntityFactory entityFactory;
    private final AzureCloudBlobIterableFactory azureCloudBlobIterableFactory;
    private final AzureCloudBlobHolderToCloudObjectLocationConverter azureCloudBlobToLocationConverter;
    private final AzureInputDataConfig inputDataConfig;

    @JsonCreator
    public AzureInputSource(@JacksonInject AzureStorage storage, @JacksonInject AzureEntityFactory entityFactory, @JacksonInject AzureCloudBlobIterableFactory azureCloudBlobIterableFactory, @JacksonInject AzureCloudBlobHolderToCloudObjectLocationConverter azureCloudBlobToLocationConverter, @JacksonInject AzureInputDataConfig inputDataConfig, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects, @JsonProperty(value="objectGlob") @Nullable String objectGlob) {
        super(SCHEME, uris, prefixes, objects, objectGlob);
        this.storage = (AzureStorage)Preconditions.checkNotNull((Object)storage, (Object)"AzureStorage");
        this.entityFactory = (AzureEntityFactory)Preconditions.checkNotNull((Object)entityFactory, (Object)"AzureEntityFactory");
        this.azureCloudBlobIterableFactory = (AzureCloudBlobIterableFactory)Preconditions.checkNotNull((Object)azureCloudBlobIterableFactory, (Object)"AzureCloudBlobIterableFactory");
        this.inputDataConfig = (AzureInputDataConfig)Preconditions.checkNotNull((Object)inputDataConfig, (Object)"AzureInputDataConfig");
        this.azureCloudBlobToLocationConverter = (AzureCloudBlobHolderToCloudObjectLocationConverter)Preconditions.checkNotNull((Object)azureCloudBlobToLocationConverter, (Object)"AzureCloudBlobToLocationConverter");
    }

    public SplittableInputSource<List<CloudObjectLocation>> withSplit(InputSplit<List<CloudObjectLocation>> split) {
        return new AzureInputSource(this.storage, this.entityFactory, this.azureCloudBlobIterableFactory, this.azureCloudBlobToLocationConverter, this.inputDataConfig, null, null, (List)split.get(), this.getObjectGlob());
    }

    protected AzureEntity createEntity(CloudObjectLocation location) {
        return this.entityFactory.create(location);
    }

    protected Stream<InputSplit<List<CloudObjectLocation>>> getPrefixesSplitStream(@Nonnull SplitHintSpec splitHintSpec) {
        Iterator splitIterator = splitHintSpec.split(this.getIterableObjectsFromPrefixes().iterator(), blobHolder -> new InputFileAttribute(blobHolder.getBlobLength()));
        return Streams.sequentialStreamFrom((Iterator)splitIterator).map(objects -> objects.stream().map(this.azureCloudBlobToLocationConverter::createCloudObjectLocation).collect(Collectors.toList())).map(InputSplit::new);
    }

    private Iterable<CloudBlobHolder> getIterableObjectsFromPrefixes() {
        return () -> {
            UnmodifiableIterator iterator = this.azureCloudBlobIterableFactory.create(this.getPrefixes(), this.inputDataConfig.getMaxListingLength()).iterator();
            if (StringUtils.isNotBlank((String)this.getObjectGlob())) {
                PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:" + this.getObjectGlob());
                iterator = Iterators.filter(iterator, object -> m.matches(Paths.get(object.getName(), new String[0])));
            }
            return iterator;
        };
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storage, this.entityFactory, this.azureCloudBlobIterableFactory, this.azureCloudBlobToLocationConverter, this.inputDataConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureInputSource that = (AzureInputSource)((Object)o);
        return this.storage.equals(that.storage) && this.entityFactory.equals(that.entityFactory) && this.azureCloudBlobIterableFactory.equals(that.azureCloudBlobIterableFactory) && this.azureCloudBlobToLocationConverter.equals(that.azureCloudBlobToLocationConverter) && this.inputDataConfig.equals(that.inputDataConfig);
    }

    public String toString() {
        return "AzureInputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + ", objectGlob=" + this.getObjectGlob() + '}';
    }
}

