/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.firehose.azure;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import org.apache.druid.firehose.azure.AzureBlob;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.azure.AzureByteSource;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.utils.CompressionUtils;

@Deprecated
public class StaticAzureBlobStoreFirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<AzureBlob> {
    private final AzureStorage azureStorage;
    private final List<AzureBlob> blobs;

    @JsonCreator
    public StaticAzureBlobStoreFirehoseFactory(@JacksonInject AzureStorage azureStorage, @JsonProperty(value="blobs") List<AzureBlob> blobs, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.blobs = blobs;
        this.azureStorage = azureStorage;
    }

    @JsonProperty
    public List<AzureBlob> getBlobs() {
        return this.blobs;
    }

    protected Collection<AzureBlob> initObjects() {
        return this.blobs;
    }

    protected InputStream openObjectStream(AzureBlob object) throws IOException {
        return StaticAzureBlobStoreFirehoseFactory.makeByteSource(this.azureStorage, object).openStream();
    }

    protected InputStream openObjectStream(AzureBlob object, long start) throws IOException {
        InputStream in = this.openObjectStream(object);
        long skip = in.skip(start);
        Preconditions.checkState((skip == start ? 1 : 0) != 0, (String)"start offset was [%s] but [%s] bytes were skipped", (Object[])new Object[]{start, skip});
        return in;
    }

    protected InputStream wrapObjectStream(AzureBlob object, InputStream stream) throws IOException {
        return CompressionUtils.decompress((InputStream)stream, (String)object.getPath());
    }

    private static AzureByteSource makeByteSource(AzureStorage azureStorage, AzureBlob object) {
        String container = object.getContainer();
        String path = StringUtils.maybeRemoveLeadingSlash((String)object.getPath());
        return new AzureByteSource(azureStorage, container, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StaticAzureBlobStoreFirehoseFactory that = (StaticAzureBlobStoreFirehoseFactory)((Object)o);
        return Objects.equals(this.blobs, that.blobs) && this.getMaxCacheCapacityBytes() == that.getMaxCacheCapacityBytes() && this.getMaxFetchCapacityBytes() == that.getMaxFetchCapacityBytes() && this.getPrefetchTriggerBytes() == that.getPrefetchTriggerBytes() && this.getFetchTimeout() == that.getFetchTimeout() && this.getMaxFetchRetry() == that.getMaxFetchRetry();
    }

    public int hashCode() {
        return Objects.hash(this.blobs, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }

    protected Predicate<Throwable> getRetryCondition() {
        return AzureUtils.AZURE_RETRY;
    }

    public FiniteFirehoseFactory<StringInputRowParser, AzureBlob> withSplit(InputSplit<AzureBlob> split) {
        return new StaticAzureBlobStoreFirehoseFactory(this.azureStorage, Collections.singletonList(split.get()), this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }
}

