/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;
import org.apache.druid.storage.azure.blob.ListBlobItemHolder;
import org.apache.druid.storage.azure.blob.ListBlobItemHolderFactory;

public class AzureCloudBlobIterator
implements Iterator<CloudBlobHolder> {
    private static final Logger log = new Logger(AzureCloudBlobIterator.class);
    private final AzureStorage storage;
    private final ListBlobItemHolderFactory blobItemDruidFactory;
    private final Iterator<URI> prefixesIterator;
    private final int maxListingLength;
    private ResultSegment<ListBlobItem> result;
    private String currentContainer;
    private String currentPrefix;
    private ResultContinuation continuationToken;
    private CloudBlobHolder currentBlobItem;
    private Iterator<ListBlobItem> blobItemIterator;
    private final AzureAccountConfig config;

    @AssistedInject
    AzureCloudBlobIterator(AzureStorage storage, ListBlobItemHolderFactory blobItemDruidFactory, AzureAccountConfig config, @Assisted Iterable<URI> prefixes, @Assisted int maxListingLength) {
        this.storage = storage;
        this.blobItemDruidFactory = blobItemDruidFactory;
        this.config = config;
        this.prefixesIterator = prefixes.iterator();
        this.maxListingLength = maxListingLength;
        this.result = null;
        this.currentContainer = null;
        this.currentPrefix = null;
        this.continuationToken = null;
        this.currentBlobItem = null;
        this.blobItemIterator = null;
        if (this.prefixesIterator.hasNext()) {
            this.prepareNextRequest();
            this.fetchNextBatch();
            this.advanceBlobItem();
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentBlobItem != null;
    }

    @Override
    public CloudBlobHolder next() {
        if (this.currentBlobItem == null) {
            throw new NoSuchElementException();
        }
        CloudBlobHolder retVal = this.currentBlobItem;
        this.advanceBlobItem();
        return retVal;
    }

    private void prepareNextRequest() {
        URI currentUri = this.prefixesIterator.next();
        this.currentContainer = currentUri.getAuthority();
        this.currentPrefix = AzureUtils.extractAzureKey(currentUri);
        log.debug("currentUri: %s\ncurrentContainer: %s\ncurrentPrefix: %s", new Object[]{currentUri, this.currentContainer, this.currentPrefix});
        this.result = null;
        this.continuationToken = null;
    }

    private void fetchNextBatch() {
        try {
            log.debug("fetching up to %s resources in container '%s' with prefix '%s'", new Object[]{this.maxListingLength, this.currentContainer, this.currentPrefix});
            this.result = (ResultSegment)AzureUtils.retryAzureOperation(() -> this.storage.listBlobsWithPrefixInContainerSegmented(this.currentContainer, this.currentPrefix, this.continuationToken, this.maxListingLength), this.config.getMaxTries());
            this.continuationToken = this.result.getContinuationToken();
            this.blobItemIterator = this.result.getResults().iterator();
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to get blob item  from Azure container[%s], prefix[%s]. Error: %s", new Object[]{this.currentContainer, this.currentPrefix, e.getMessage()});
        }
    }

    private void advanceBlobItem() {
        while (this.blobItemIterator.hasNext() || this.continuationToken != null || this.prefixesIterator.hasNext()) {
            while (this.blobItemIterator.hasNext()) {
                ListBlobItemHolder blobItem = this.blobItemDruidFactory.create(this.blobItemIterator.next());
                if (!blobItem.isCloudBlob() || blobItem.getCloudBlob().getBlobLength() <= 0L) continue;
                this.currentBlobItem = blobItem.getCloudBlob();
                return;
            }
            if (this.continuationToken != null) {
                this.fetchNextBatch();
                continue;
            }
            if (!this.prefixesIterator.hasNext()) continue;
            this.prepareNextRequest();
            this.fetchNextBatch();
        }
        this.currentBlobItem = null;
    }
}

