/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.druid.java.util.common.logger.Logger;

public class AzureStorage {
    private static final boolean USE_FLAT_BLOB_LISTING = true;
    private static final Logger log = new Logger(AzureStorage.class);
    private final Supplier<CloudBlobClient> cloudBlobClient;

    public AzureStorage(Supplier<CloudBlobClient> cloudBlobClient) {
        this.cloudBlobClient = cloudBlobClient;
    }

    public List<String> emptyCloudBlobDirectory(String containerName, String virtualDirPath) throws StorageException, URISyntaxException {
        ArrayList<String> deletedFiles = new ArrayList<String>();
        CloudBlobContainer container = this.getOrCreateCloudBlobContainer(containerName);
        for (ListBlobItem blobItem : container.listBlobs(virtualDirPath, true, null, null, null)) {
            CloudBlob cloudBlob = (CloudBlob)blobItem;
            log.info("Removing file[%s] from Azure.", new Object[]{cloudBlob.getName()});
            if (!cloudBlob.deleteIfExists()) continue;
            deletedFiles.add(cloudBlob.getName());
        }
        if (deletedFiles.isEmpty()) {
            log.warn("No files were deleted on the following Azure path: [%s]", new Object[]{virtualDirPath});
        }
        return deletedFiles;
    }

    public void uploadBlob(File file, String containerName, String blobPath) throws IOException, StorageException, URISyntaxException {
        CloudBlobContainer container = this.getOrCreateCloudBlobContainer(containerName);
        try (FileInputStream stream = new FileInputStream(file);){
            container.getBlockBlobReference(blobPath).upload((InputStream)stream, file.length());
        }
    }

    public long getBlobLength(String containerName, String blobPath) throws URISyntaxException, StorageException {
        return this.getOrCreateCloudBlobContainer(containerName).getBlockBlobReference(blobPath).getProperties().getLength();
    }

    public InputStream getBlobInputStream(String containerName, String blobPath) throws URISyntaxException, StorageException {
        return this.getBlobInputStream(0L, containerName, blobPath);
    }

    public InputStream getBlobInputStream(long offset, String containerName, String blobPath) throws URISyntaxException, StorageException {
        CloudBlobContainer container = this.getOrCreateCloudBlobContainer(containerName);
        return container.getBlockBlobReference(blobPath).openInputStream(offset, null, null, null, null);
    }

    public boolean getBlobExists(String container, String blobPath) throws URISyntaxException, StorageException {
        return this.getOrCreateCloudBlobContainer(container).getBlockBlobReference(blobPath).exists();
    }

    @VisibleForTesting
    CloudBlobClient getCloudBlobClient() {
        return (CloudBlobClient)this.cloudBlobClient.get();
    }

    @VisibleForTesting
    ResultSegment<ListBlobItem> listBlobsWithPrefixInContainerSegmented(String containerName, String prefix, ResultContinuation continuationToken, int maxResults) throws StorageException, URISyntaxException {
        CloudBlobContainer cloudBlobContainer = ((CloudBlobClient)this.cloudBlobClient.get()).getContainerReference(containerName);
        return cloudBlobContainer.listBlobsSegmented(prefix, true, EnumSet.noneOf(BlobListingDetails.class), Integer.valueOf(maxResults), continuationToken, null, null);
    }

    private CloudBlobContainer getOrCreateCloudBlobContainer(String containerName) throws StorageException, URISyntaxException {
        CloudBlobContainer cloudBlobContainer = ((CloudBlobClient)this.cloudBlobClient.get()).getContainerReference(containerName);
        cloudBlobContainer.createIfNotExists();
        return cloudBlobContainer;
    }
}

